
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "classLabels",
    "matrix"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ConfusionMatrix")
@JsonPropertyOrder({
    "extensions",
    "classLabels",
    "matrix"
})
public class ConfusionMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ConfusionMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ClassLabels", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ClassLabels")
    private ClassLabels classLabels;
    @XmlElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Matrix")
    private Matrix matrix;
    private final static long serialVersionUID = 67371266L;

    public ConfusionMatrix() {
    }

    @ValueConstructor
    public ConfusionMatrix(
        @org.jpmml.model.annotations.Property("classLabels")
        ClassLabels classLabels,
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.classLabels = classLabels;
        this.matrix = matrix;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ConfusionMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ClassLabels getClassLabels() {
        return classLabels;
    }

    public ConfusionMatrix setClassLabels(
        @org.jpmml.model.annotations.Property("classLabels")
        ClassLabels classLabels) {
        this.classLabels = classLabels;
        return this;
    }

    public Matrix getMatrix() {
        return matrix;
    }

    public ConfusionMatrix setMatrix(
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getClassLabels(), getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
