
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("NormDiscrete")
@JsonPropertyOrder({
    "field",
    "method",
    "value",
    "mapMissingTo",
    "extensions"
})
public class NormDiscrete
    extends Expression
    implements HasExtensions<NormDiscrete> , HasFieldReference<NormDiscrete> , HasMapMissingTo<NormDiscrete, Number> , HasValue<NormDiscrete>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "method")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("method")
    private NormDiscrete.Method method;
    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "mapMissingTo")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("mapMissingTo")
    private Number mapMissingTo;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371266L;

    public NormDiscrete() {
    }

    @ValueConstructor
    public NormDiscrete(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public NormDiscrete setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public NormDiscrete.Method getMethod() {
        if (method == null) {
            return NormDiscrete.Method.INDICATOR;
        } else {
            return method;
        }
    }

    public NormDiscrete setMethod(
        @org.jpmml.model.annotations.Property("method")
        NormDiscrete.Method method) {
        this.method = method;
        return this;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public NormDiscrete setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Number getMapMissingTo() {
        return mapMissingTo;
    }

    @Override
    public NormDiscrete setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Number mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NormDiscrete addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Method
        implements StringValue<NormDiscrete.Method>
    {

        @XmlEnumValue("indicator")
        @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_4_3))
        @JsonProperty("indicator")
        INDICATOR("indicator"),
        @XmlEnumValue("thermometer")
        @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_2))
        @JsonProperty("thermometer")
        THERMOMETER("thermometer");
        private final String value;

        Method(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static NormDiscrete.Method fromValue(String v) {
            for (NormDiscrete.Method c: NormDiscrete.Method.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
