
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@Deprecated((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("DecisionTree")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "missingValueStrategy",
    "missingValuePenalty",
    "noTrueChildStrategy",
    "splitCharacteristic",
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
public class DecisionTree
    extends EmbeddedModel
    implements HasExtensions<DecisionTree>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("missingValueStrategy")
    private DecisionTree.MissingValueStrategy missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("missingValuePenalty")
    private Number missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("noTrueChildStrategy")
    private DecisionTree.NoTrueChildStrategy noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    @JsonProperty("splitCharacteristic")
    private DecisionTree.SplitCharacteristic splitCharacteristic;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ResultField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ResultField")
    private List<ResultField> resultFields;
    @XmlElements({
        @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_4", required = true, type = org.dmg.pmml.tree.ComplexNode.class)
    })
    @JsonProperty("Node")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NONE, defaultImpl = org.dmg.pmml.tree.ComplexNode.class)
    @JsonDeserialize(as = org.dmg.pmml.tree.ComplexNode.class)
    private Node node;
    private final static Number DEFAULT_MISSING_VALUE_PENALTY = new ProbabilityNumberAdapter().unmarshal("1.0");
    private final static long serialVersionUID = 67371266L;

    public DecisionTree() {
    }

    @ValueConstructor
    public DecisionTree(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.miningFunction = miningFunction;
        this.node = node;
    }

    public String getModelName() {
        return modelName;
    }

    public DecisionTree setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public DecisionTree setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public DecisionTree setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public DecisionTree.MissingValueStrategy getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return DecisionTree.MissingValueStrategy.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    public DecisionTree setMissingValueStrategy(
        @org.jpmml.model.annotations.Property("missingValueStrategy")
        DecisionTree.MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    public Number getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        } else {
            return missingValuePenalty;
        }
    }

    public DecisionTree setMissingValuePenalty(
        @org.jpmml.model.annotations.Property("missingValuePenalty")
        Number missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    public DecisionTree.NoTrueChildStrategy getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return DecisionTree.NoTrueChildStrategy.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    public DecisionTree setNoTrueChildStrategy(
        @org.jpmml.model.annotations.Property("noTrueChildStrategy")
        DecisionTree.NoTrueChildStrategy noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    public DecisionTree.SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return DecisionTree.SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    public DecisionTree setSplitCharacteristic(
        @org.jpmml.model.annotations.Property("splitCharacteristic")
        DecisionTree.SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DecisionTree addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public DecisionTree setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public DecisionTree setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public DecisionTree setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public DecisionTree setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasResultFields() {
        return ((this.resultFields!= null)&&(this.resultFields.size()> 0));
    }

    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public DecisionTree addResultFields(ResultField... resultFields) {
        getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    public Node getNode() {
        return node;
    }

    public DecisionTree setNode(
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.node = node;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getOutput(), getModelStats(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasResultFields()) {
                status = PMMLObject.traverse(visitor, getResultFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNode());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum MissingValueStrategy
        implements StringValue<DecisionTree.MissingValueStrategy>
    {

        @XmlEnumValue("lastPrediction")
        @JsonProperty("lastPrediction")
        LAST_PREDICTION("lastPrediction"),
        @XmlEnumValue("nullPrediction")
        @JsonProperty("nullPrediction")
        NULL_PREDICTION("nullPrediction"),
        @XmlEnumValue("defaultChild")
        @JsonProperty("defaultChild")
        DEFAULT_CHILD("defaultChild"),
        @XmlEnumValue("weightedConfidence")
        @JsonProperty("weightedConfidence")
        WEIGHTED_CONFIDENCE("weightedConfidence"),
        @XmlEnumValue("aggregateNodes")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
        @JsonProperty("aggregateNodes")
        AGGREGATE_NODES("aggregateNodes"),
        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none");
        private final String value;

        MissingValueStrategy(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DecisionTree.MissingValueStrategy fromValue(String v) {
            for (DecisionTree.MissingValueStrategy c: DecisionTree.MissingValueStrategy.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum NoTrueChildStrategy
        implements StringValue<DecisionTree.NoTrueChildStrategy>
    {

        @XmlEnumValue("returnNullPrediction")
        @JsonProperty("returnNullPrediction")
        RETURN_NULL_PREDICTION("returnNullPrediction"),
        @XmlEnumValue("returnLastPrediction")
        @JsonProperty("returnLastPrediction")
        RETURN_LAST_PREDICTION("returnLastPrediction");
        private final String value;

        NoTrueChildStrategy(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DecisionTree.NoTrueChildStrategy fromValue(String v) {
            for (DecisionTree.NoTrueChildStrategy c: DecisionTree.NoTrueChildStrategy.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum SplitCharacteristic
        implements StringValue<DecisionTree.SplitCharacteristic>
    {

        @XmlEnumValue("binarySplit")
        @JsonProperty("binarySplit")
        BINARY_SPLIT("binarySplit"),
        @XmlEnumValue("multiSplit")
        @JsonProperty("multiSplit")
        MULTI_SPLIT("multiSplit");
        private final String value;

        SplitCharacteristic(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DecisionTree.SplitCharacteristic fromValue(String v) {
            for (DecisionTree.SplitCharacteristic c: DecisionTree.SplitCharacteristic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
