
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "MultivariateStat", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("MultivariateStat")
@JsonPropertyOrder({
    "name",
    "category",
    "exponent",
    "intercept",
    "importance",
    "stdError",
    "tValue",
    "chiSquareValue",
    "fStatistic",
    "df",
    "pValueAlpha",
    "pValueInitial",
    "pValueFinal",
    "confidenceLevel",
    "confidenceLowerBound",
    "confidenceUpperBound",
    "extensions"
})
public class MultivariateStat
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MultivariateStat>
{

    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "category")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("category")
    private Object category;
    @XmlAttribute(name = "exponent")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("exponent")
    private Integer exponent;
    @XmlAttribute(name = "isIntercept")
    @JsonProperty("isIntercept")
    private Boolean intercept;
    @XmlAttribute(name = "importance")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("importance")
    private Number importance;
    @XmlAttribute(name = "stdError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("stdError")
    private Number stdError;
    @XmlAttribute(name = "tValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("tValue")
    private Number tValue;
    @XmlAttribute(name = "chiSquareValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("chiSquareValue")
    private Number chiSquareValue;
    @XmlAttribute(name = "fStatistic")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("fStatistic")
    private Number fStatistic;
    @XmlAttribute(name = "dF")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("dF")
    private Number df;
    @XmlAttribute(name = "pValueAlpha")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("pValueAlpha")
    private Number pValueAlpha;
    @XmlAttribute(name = "pValueInitial")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("pValueInitial")
    private Number pValueInitial;
    @XmlAttribute(name = "pValueFinal")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("pValueFinal")
    private Number pValueFinal;
    @XmlAttribute(name = "confidenceLevel")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("confidenceLevel")
    private Number confidenceLevel;
    @XmlAttribute(name = "confidenceLowerBound")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("confidenceLowerBound")
    private Number confidenceLowerBound;
    @XmlAttribute(name = "confidenceUpperBound")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("confidenceUpperBound")
    private Number confidenceUpperBound;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Integer DEFAULT_EXPONENT = new IntegerAdapter().unmarshal("1");
    private final static Boolean DEFAULT_INTERCEPT = false;
    private final static Number DEFAULT_CONFIDENCE_LEVEL = new ProbabilityNumberAdapter().unmarshal("0.95");
    private final static long serialVersionUID = 67371267L;

    public String getName() {
        return name;
    }

    public MultivariateStat setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Object getCategory() {
        return category;
    }

    public MultivariateStat setCategory(
        @Property("category")
        Object category) {
        this.category = category;
        return this;
    }

    public Integer getExponent() {
        if (exponent == null) {
            return DEFAULT_EXPONENT;
        } else {
            return exponent;
        }
    }

    public MultivariateStat setExponent(
        @Property("exponent")
        Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    public boolean isIntercept() {
        if (intercept == null) {
            return DEFAULT_INTERCEPT;
        } else {
            return intercept;
        }
    }

    public MultivariateStat setIntercept(
        @Property("intercept")
        Boolean intercept) {
        this.intercept = intercept;
        return this;
    }

    public Number getImportance() {
        return importance;
    }

    public MultivariateStat setImportance(
        @Property("importance")
        Number importance) {
        this.importance = importance;
        return this;
    }

    public Number getStdError() {
        return stdError;
    }

    public MultivariateStat setStdError(
        @Property("stdError")
        Number stdError) {
        this.stdError = stdError;
        return this;
    }

    public Number getTValue() {
        return tValue;
    }

    public MultivariateStat setTValue(
        @Property("tValue")
        Number tValue) {
        this.tValue = tValue;
        return this;
    }

    public Number getChiSquareValue() {
        return chiSquareValue;
    }

    public MultivariateStat setChiSquareValue(
        @Property("chiSquareValue")
        Number chiSquareValue) {
        this.chiSquareValue = chiSquareValue;
        return this;
    }

    public Number getFStatistic() {
        return fStatistic;
    }

    public MultivariateStat setFStatistic(
        @Property("fStatistic")
        Number fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    public Number getDF() {
        return df;
    }

    public MultivariateStat setDF(
        @Property("df")
        Number df) {
        this.df = df;
        return this;
    }

    public Number getPValueAlpha() {
        return pValueAlpha;
    }

    public MultivariateStat setPValueAlpha(
        @Property("pValueAlpha")
        Number pValueAlpha) {
        this.pValueAlpha = pValueAlpha;
        return this;
    }

    public Number getPValueInitial() {
        return pValueInitial;
    }

    public MultivariateStat setPValueInitial(
        @Property("pValueInitial")
        Number pValueInitial) {
        this.pValueInitial = pValueInitial;
        return this;
    }

    public Number getPValueFinal() {
        return pValueFinal;
    }

    public MultivariateStat setPValueFinal(
        @Property("pValueFinal")
        Number pValueFinal) {
        this.pValueFinal = pValueFinal;
        return this;
    }

    public Number getConfidenceLevel() {
        if (confidenceLevel == null) {
            return DEFAULT_CONFIDENCE_LEVEL;
        } else {
            return confidenceLevel;
        }
    }

    public MultivariateStat setConfidenceLevel(
        @Property("confidenceLevel")
        Number confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    public Number getConfidenceLowerBound() {
        return confidenceLowerBound;
    }

    public MultivariateStat setConfidenceLowerBound(
        @Property("confidenceLowerBound")
        Number confidenceLowerBound) {
        this.confidenceLowerBound = confidenceLowerBound;
        return this;
    }

    public Number getConfidenceUpperBound() {
        return confidenceUpperBound;
    }

    public MultivariateStat setConfidenceUpperBound(
        @Property("confidenceUpperBound")
        Number confidenceUpperBound) {
        this.confidenceUpperBound = confidenceUpperBound;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MultivariateStat addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
