
package org.dmg.pmml.anomaly_detection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AnomalyDetectionModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "localTransformations",
    "modelVerification",
    "model",
    "meanClusterDistances"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("AnomalyDetectionModel")
@JsonPropertyOrder({
    "modelName",
    "algorithmName",
    "miningFunction",
    "algorithmType",
    "sampleDataSize",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "localTransformations",
    "modelVerification",
    "model",
    "meanClusterDistances"
})
public class AnomalyDetectionModel
    extends org.dmg.pmml.Model
    implements HasExtensions<AnomalyDetectionModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmType", required = true)
    @JsonProperty("algorithmType")
    private String algorithmType;
    @XmlAttribute(name = "sampleDataSize")
    @JsonProperty("sampleDataSize")
    private String sampleDataSize;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    @XmlElements({
        @XmlElement(name = "AnomalyDetectionModel", namespace = "http://www.dmg.org/PMML-4_4", type = AnomalyDetectionModel.class),
        @XmlElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.association.AssociationModel.class),
        @XmlElement(name = "BayesianNetworkModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @XmlElement(name = "BaselineModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.baseline.BaselineModel.class),
        @XmlElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.clustering.ClusteringModel.class),
        @XmlElement(name = "GaussianProcessModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @XmlElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.mining.MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.regression.RegressionModel.class),
        @XmlElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.rule_set.RuleSetModel.class),
        @XmlElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.sequence.SequenceModel.class),
        @XmlElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.scorecard.Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.text.TextModel.class),
        @XmlElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.tree.TreeModel.class)
    })
    @JsonProperty("Model")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AnomalyDetectionModel", value = org.dmg.pmml.anomaly_detection.AnomalyDetectionModel.class),
        @JsonSubTypes.Type(name = "AssociationModel", value = org.dmg.pmml.association.AssociationModel.class),
        @JsonSubTypes.Type(name = "BayesianNetworkModel", value = org.dmg.pmml.bayesian_network.BayesianNetworkModel.class),
        @JsonSubTypes.Type(name = "BaselineModel", value = org.dmg.pmml.baseline.BaselineModel.class),
        @JsonSubTypes.Type(name = "ClusteringModel", value = org.dmg.pmml.clustering.ClusteringModel.class),
        @JsonSubTypes.Type(name = "GaussianProcessModel", value = org.dmg.pmml.gaussian_process.GaussianProcessModel.class),
        @JsonSubTypes.Type(name = "GeneralRegressionModel", value = org.dmg.pmml.general_regression.GeneralRegressionModel.class),
        @JsonSubTypes.Type(name = "MiningModel", value = org.dmg.pmml.mining.MiningModel.class),
        @JsonSubTypes.Type(name = "NaiveBayesModel", value = org.dmg.pmml.naive_bayes.NaiveBayesModel.class),
        @JsonSubTypes.Type(name = "NearestNeighborModel", value = org.dmg.pmml.nearest_neighbor.NearestNeighborModel.class),
        @JsonSubTypes.Type(name = "NeuralNetwork", value = org.dmg.pmml.neural_network.NeuralNetwork.class),
        @JsonSubTypes.Type(name = "RegressionModel", value = org.dmg.pmml.regression.RegressionModel.class),
        @JsonSubTypes.Type(name = "RuleSetModel", value = org.dmg.pmml.rule_set.RuleSetModel.class),
        @JsonSubTypes.Type(name = "SequenceModel", value = org.dmg.pmml.sequence.SequenceModel.class),
        @JsonSubTypes.Type(name = "Scorecard", value = org.dmg.pmml.scorecard.Scorecard.class),
        @JsonSubTypes.Type(name = "SupportVectorMachineModel", value = org.dmg.pmml.support_vector_machine.SupportVectorMachineModel.class),
        @JsonSubTypes.Type(name = "TextModel", value = org.dmg.pmml.text.TextModel.class),
        @JsonSubTypes.Type(name = "TimeSeriesModel", value = org.dmg.pmml.time_series.TimeSeriesModel.class),
        @JsonSubTypes.Type(name = "TreeModel", value = org.dmg.pmml.tree.TreeModel.class)
    })
    private org.dmg.pmml.Model model;
    @XmlElement(name = "MeanClusterDistances", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MeanClusterDistances")
    private MeanClusterDistances meanClusterDistances;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371267L;

    public AnomalyDetectionModel() {
    }

    @ValueConstructor
    public AnomalyDetectionModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("algorithmType")
        String algorithmType,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("model")
        org.dmg.pmml.Model model) {
        this.miningFunction = miningFunction;
        this.algorithmType = algorithmType;
        this.miningSchema = miningSchema;
        this.model = model;
    }

    public String getModelName() {
        return modelName;
    }

    public AnomalyDetectionModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public AnomalyDetectionModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public AnomalyDetectionModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmType() {
        return algorithmType;
    }

    public AnomalyDetectionModel setAlgorithmType(
        @org.jpmml.model.annotations.Property("algorithmType")
        String algorithmType) {
        this.algorithmType = algorithmType;
        return this;
    }

    public String getSampleDataSize() {
        return sampleDataSize;
    }

    public AnomalyDetectionModel setSampleDataSize(
        @org.jpmml.model.annotations.Property("sampleDataSize")
        String sampleDataSize) {
        this.sampleDataSize = sampleDataSize;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public AnomalyDetectionModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public AnomalyDetectionModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AnomalyDetectionModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public AnomalyDetectionModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public AnomalyDetectionModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public AnomalyDetectionModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public AnomalyDetectionModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public org.dmg.pmml.Model getModel() {
        return model;
    }

    public AnomalyDetectionModel setModel(
        @org.jpmml.model.annotations.Property("model")
        org.dmg.pmml.Model model) {
        this.model = model;
        return this;
    }

    public MeanClusterDistances getMeanClusterDistances() {
        return meanClusterDistances;
    }

    public AnomalyDetectionModel setMeanClusterDistances(
        @org.jpmml.model.annotations.Property("meanClusterDistances")
        MeanClusterDistances meanClusterDistances) {
        this.meanClusterDistances = meanClusterDistances;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getLocalTransformations(), getModelVerification(), getModel(), getMeanClusterDistances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
