
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("KohonenMap")
@JsonPropertyOrder({
    "coord1",
    "coord2",
    "coord3",
    "extensions"
})
public class KohonenMap
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<KohonenMap>
{

    @XmlAttribute(name = "coord1")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coord1")
    private Number coord1;
    @XmlAttribute(name = "coord2")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coord2")
    private Number coord2;
    @XmlAttribute(name = "coord3")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coord3")
    private Number coord3;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371268L;

    public Number getCoord1() {
        return coord1;
    }

    public KohonenMap setCoord1(
        @Property("coord1")
        Number coord1) {
        this.coord1 = coord1;
        return this;
    }

    public Number getCoord2() {
        return coord2;
    }

    public KohonenMap setCoord2(
        @Property("coord2")
        Number coord2) {
        this.coord2 = coord2;
        return this;
    }

    public Number getCoord3() {
        return coord3;
    }

    public KohonenMap setCoord3(
        @Property("coord3")
        Number coord3) {
        this.coord3 = coord3;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KohonenMap addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
