
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("Segmentation")
@JsonPropertyOrder({
    "multipleModelMethod",
    "missingPredictionTreatment",
    "missingThreshold",
    "extensions",
    "localTransformations",
    "segments"
})
public class Segmentation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Segmentation>
{

    @XmlAttribute(name = "multipleModelMethod", required = true)
    @JsonProperty("multipleModelMethod")
    private Segmentation.MultipleModelMethod multipleModelMethod;
    @XmlAttribute(name = "missingPredictionTreatment")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("missingPredictionTreatment")
    private Segmentation.MissingPredictionTreatment missingPredictionTreatment;
    @XmlAttribute(name = "missingThreshold")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("missingThreshold")
    private Number missingThreshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @Removed((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Segment")
    private List<Segment> segments;
    private final static Number DEFAULT_MISSING_THRESHOLD = new ProbabilityNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371268L;

    public Segmentation() {
    }

    @ValueConstructor
    public Segmentation(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod,
        @org.jpmml.model.annotations.Property("segments")
        List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    public Segmentation.MultipleModelMethod getMultipleModelMethod() {
        return multipleModelMethod;
    }

    public Segmentation setMultipleModelMethod(
        @org.jpmml.model.annotations.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    public Segmentation.MissingPredictionTreatment getMissingPredictionTreatment() {
        if (missingPredictionTreatment == null) {
            return Segmentation.MissingPredictionTreatment.CONTINUE;
        } else {
            return missingPredictionTreatment;
        }
    }

    public Segmentation setMissingPredictionTreatment(
        @org.jpmml.model.annotations.Property("missingPredictionTreatment")
        Segmentation.MissingPredictionTreatment missingPredictionTreatment) {
        this.missingPredictionTreatment = missingPredictionTreatment;
        return this;
    }

    public Number getMissingThreshold() {
        if (missingThreshold == null) {
            return DEFAULT_MISSING_THRESHOLD;
        } else {
            return missingThreshold;
        }
    }

    public Segmentation setMissingThreshold(
        @org.jpmml.model.annotations.Property("missingThreshold")
        Number missingThreshold) {
        this.missingThreshold = missingThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Segmentation addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public Segmentation setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasSegments() {
        return ((this.segments!= null)&&(this.segments.size()> 0));
    }

    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public Segmentation addSegments(Segment... segments) {
        getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSegments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    public enum MissingPredictionTreatment
        implements StringValue<Segmentation.MissingPredictionTreatment>
    {

        @XmlEnumValue("returnMissing")
        @JsonProperty("returnMissing")
        RETURN_MISSING("returnMissing"),
        @XmlEnumValue("skipSegment")
        @JsonProperty("skipSegment")
        SKIP_SEGMENT("skipSegment"),
        @XmlEnumValue("continue")
        @JsonProperty("continue")
        CONTINUE("continue");
        private final String value;

        MissingPredictionTreatment(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Segmentation.MissingPredictionTreatment fromValue(String v) {
            for (Segmentation.MissingPredictionTreatment c: Segmentation.MissingPredictionTreatment.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum MultipleModelMethod
        implements StringValue<Segmentation.MultipleModelMethod>
    {

        @XmlEnumValue("majorityVote")
        @JsonProperty("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        @JsonProperty("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        @XmlEnumValue("average")
        @JsonProperty("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        @JsonProperty("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage"),
        @XmlEnumValue("median")
        @JsonProperty("median")
        MEDIAN("median"),
        @XmlEnumValue("weightedMedian")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
        @JsonProperty("weightedMedian")
        WEIGHTED_MEDIAN("weightedMedian"),
        @XmlEnumValue("max")
        @JsonProperty("max")
        MAX("max"),
        @XmlEnumValue("sum")
        @JsonProperty("sum")
        SUM("sum"),
        @XmlEnumValue("weightedSum")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
        @JsonProperty("weightedSum")
        WEIGHTED_SUM("weightedSum"),
        @XmlEnumValue("selectFirst")
        @JsonProperty("selectFirst")
        SELECT_FIRST("selectFirst"),
        @XmlEnumValue("selectAll")
        @JsonProperty("selectAll")
        SELECT_ALL("selectAll"),
        @XmlEnumValue("modelChain")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("modelChain")
        MODEL_CHAIN("modelChain");
        private final String value;

        MultipleModelMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Segmentation.MultipleModelMethod fromValue(String v) {
            for (Segmentation.MultipleModelMethod c: Segmentation.MultipleModelMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
