
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "vectorFields",
    "vectorInstances"
})
@JsonRootName("VectorDictionary")
@JsonPropertyOrder({
    "numberOfVectors",
    "extensions",
    "vectorFields",
    "vectorInstances"
})
public class VectorDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<VectorDictionary>
{

    @XmlAttribute(name = "numberOfVectors")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfVectors")
    private Integer numberOfVectors;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("VectorFields")
    private VectorFields vectorFields;
    @XmlElement(name = "VectorInstance", namespace = "http://www.dmg.org/PMML-4_4")
    @Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("VectorInstance")
    private List<VectorInstance> vectorInstances;
    private final static long serialVersionUID = 67371268L;

    public VectorDictionary() {
    }

    @ValueConstructor
    public VectorDictionary(
        @org.jpmml.model.annotations.Property("vectorFields")
        VectorFields vectorFields) {
        this.vectorFields = vectorFields;
    }

    public Integer getNumberOfVectors() {
        return numberOfVectors;
    }

    public VectorDictionary setNumberOfVectors(
        @org.jpmml.model.annotations.Property("numberOfVectors")
        Integer numberOfVectors) {
        this.numberOfVectors = numberOfVectors;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VectorDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public VectorFields getVectorFields() {
        return vectorFields;
    }

    public VectorDictionary setVectorFields(
        @org.jpmml.model.annotations.Property("vectorFields")
        VectorFields vectorFields) {
        this.vectorFields = vectorFields;
        return this;
    }

    public boolean hasVectorInstances() {
        return ((this.vectorInstances!= null)&&(this.vectorInstances.size()> 0));
    }

    public List<VectorInstance> getVectorInstances() {
        if (vectorInstances == null) {
            vectorInstances = new ArrayList<VectorInstance>();
        }
        return this.vectorInstances;
    }

    public VectorDictionary addVectorInstances(VectorInstance... vectorInstances) {
        getVectorInstances().addAll(Arrays.asList(vectorInstances));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasVectorInstances()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVectorInstances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
