
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasScoreDistributions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "scoreDistributions"
})
@JsonRootName("SimpleRule")
@JsonPropertyOrder({
    "id",
    "score",
    "recordCount",
    "nbCorrect",
    "confidence",
    "weight",
    "extensions",
    "predicate",
    "scoreDistributions"
})
public class SimpleRule
    extends Rule
    implements HasExtensions<SimpleRule> , HasScoreDistributions<SimpleRule>
{

    @XmlAttribute(name = "id")
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "score", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("score")
    private Object score;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("recordCount")
    private Number recordCount;
    @XmlAttribute(name = "nbCorrect")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("nbCorrect")
    private Number nbCorrect;
    @XmlAttribute(name = "confidence")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("confidence")
    private Number confidence;
    @XmlAttribute(name = "weight")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("weight")
    private Number weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ScoreDistribution")
    private List<ScoreDistribution> scoreDistributions;
    private final static Number DEFAULT_CONFIDENCE = new NumberAdapter().unmarshal("1");
    private final static Number DEFAULT_WEIGHT = new NumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371268L;

    public SimpleRule() {
    }

    @ValueConstructor
    public SimpleRule(
        @org.jpmml.model.annotations.Property("score")
        Object score,
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.score = score;
        this.predicate = predicate;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public SimpleRule setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    @Override
    public Object getScore() {
        return score;
    }

    @Override
    public SimpleRule setScore(
        @org.jpmml.model.annotations.Property("score")
        Object score) {
        this.score = score;
        return this;
    }

    public Number getRecordCount() {
        return recordCount;
    }

    public SimpleRule setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Number getNbCorrect() {
        return nbCorrect;
    }

    public SimpleRule setNbCorrect(
        @org.jpmml.model.annotations.Property("nbCorrect")
        Number nbCorrect) {
        this.nbCorrect = nbCorrect;
        return this;
    }

    public Number getConfidence() {
        if (confidence == null) {
            return DEFAULT_CONFIDENCE;
        } else {
            return confidence;
        }
    }

    public SimpleRule setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number getWeight() {
        if (weight == null) {
            return DEFAULT_WEIGHT;
        } else {
            return weight;
        }
    }

    public SimpleRule setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Number weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SimpleRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public SimpleRule setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    @Override
    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    @Override
    public SimpleRule addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, getScoreDistributions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
