
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Parameter", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Parameter")
@JsonPropertyOrder({
    "name",
    "label",
    "referencePoint",
    "extensions"
})
public class Parameter
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Parameter> , Indexable<String>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "label")
    @JsonProperty("label")
    private String label;
    @XmlAttribute(name = "referencePoint")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("referencePoint")
    private Number referencePoint;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Number DEFAULT_REFERENCE_POINT = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371011L;

    public Parameter() {
    }

    @ValueConstructor
    public Parameter(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    @Override
    public String getKey() {
        return getName();
    }

    public String getName() {
        return name;
    }

    public Parameter setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return label;
    }

    public Parameter setLabel(
        @org.jpmml.model.annotations.Property("label")
        String label) {
        this.label = label;
        return this;
    }

    public Number getReferencePoint() {
        if (referencePoint == null) {
            return DEFAULT_REFERENCE_POINT;
        } else {
            return referencePoint;
        }
    }

    public Parameter setReferencePoint(
        @org.jpmml.model.annotations.Property("referencePoint")
        Number referencePoint) {
        this.referencePoint = referencePoint;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Parameter addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
