
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.Itemset;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
@JsonRootName("SequenceModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfTransactions",
    "maxNumberOfItemsPerTransaction",
    "avgNumberOfItemsPerTransaction",
    "numberOfTransactionGroups",
    "maxNumberOfTAsPerTAGroup",
    "avgNumberOfTAsPerTAGroup",
    "minimumSupport",
    "minimumConfidence",
    "lengthLimit",
    "numberOfItems",
    "numberOfSets",
    "numberOfSequences",
    "numberOfRules",
    "timeWindowWidth",
    "minimumTime",
    "maximumTime",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
public class SequenceModel
    extends Model
    implements HasExtensions<SequenceModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maxNumberOfItemsPerTransaction")
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name = "avgNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("avgNumberOfItemsPerTransaction")
    private Number avgNumberOfItemsPerTransaction;
    @XmlAttribute(name = "numberOfTransactionGroups")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("numberOfTransactionGroups")
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name = "maxNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("maxNumberOfTAsPerTAGroup")
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "avgNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("avgNumberOfTAsPerTAGroup")
    private Number avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "minimumSupport", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("minimumSupport")
    private Number minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("minimumConfidence")
    private Number minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("lengthLimit")
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("numberOfItems")
    private Integer numberOfItems;
    @XmlAttribute(name = "numberOfSets", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name = "numberOfSequences", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("numberOfSequences")
    private Integer numberOfSequences;
    @XmlAttribute(name = "numberOfRules", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("numberOfRules")
    private Integer numberOfRules;
    @XmlAttribute(name = "timeWindowWidth")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("timeWindowWidth")
    private Integer timeWindowWidth;
    @XmlAttribute(name = "minimumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("minimumTime")
    private Integer minimumTime;
    @XmlAttribute(name = "maximumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("maximumTime")
    private Integer maximumTime;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("Constraints")
    private Constraints constraints;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Item")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Itemset")
    private List<Itemset> itemsets;
    @XmlElement(name = "SetPredicate", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SetPredicate")
    private List<SetPredicate> setPredicates;
    @XmlElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Sequence")
    private List<Sequence> sequences;
    @XmlElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SequenceRule")
    private List<SequenceRule> sequenceRules;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371011L;

    public SequenceModel() {
    }

    @ValueConstructor
    public SequenceModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport,
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence,
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems,
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets,
        @org.jpmml.model.annotations.Property("numberOfSequences")
        Integer numberOfSequences,
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("sequences")
        List<Sequence> sequences) {
        this.miningFunction = miningFunction;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    public String getModelName() {
        return modelName;
    }

    public SequenceModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public SequenceModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public SequenceModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return numberOfTransactions;
    }

    public SequenceModel setNumberOfTransactions(
        @org.jpmml.model.annotations.Property("numberOfTransactions")
        Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTransaction() {
        return maxNumberOfItemsPerTransaction;
    }

    public SequenceModel setMaxNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("maxNumberOfItemsPerTransaction")
        Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    public Number getAvgNumberOfItemsPerTransaction() {
        return avgNumberOfItemsPerTransaction;
    }

    public SequenceModel setAvgNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("avgNumberOfItemsPerTransaction")
        Number avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    public Integer getNumberOfTransactionGroups() {
        return numberOfTransactionGroups;
    }

    public SequenceModel setNumberOfTransactionGroups(
        @org.jpmml.model.annotations.Property("numberOfTransactionGroups")
        Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    public Integer getMaxNumberOfTAsPerTAGroup() {
        return maxNumberOfTAsPerTAGroup;
    }

    public SequenceModel setMaxNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("maxNumberOfTAsPerTAGroup")
        Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    public Number getAvgNumberOfTAsPerTAGroup() {
        return avgNumberOfTAsPerTAGroup;
    }

    public SequenceModel setAvgNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("avgNumberOfTAsPerTAGroup")
        Number avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    public Number getMinimumSupport() {
        return minimumSupport;
    }

    public SequenceModel setMinimumSupport(
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number getMinimumConfidence() {
        return minimumConfidence;
    }

    public SequenceModel setMinimumConfidence(
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return lengthLimit;
    }

    public SequenceModel setLengthLimit(
        @org.jpmml.model.annotations.Property("lengthLimit")
        Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    public SequenceModel setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    public SequenceModel setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer getNumberOfSequences() {
        return numberOfSequences;
    }

    public SequenceModel setNumberOfSequences(
        @org.jpmml.model.annotations.Property("numberOfSequences")
        Integer numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    public Integer getNumberOfRules() {
        return numberOfRules;
    }

    public SequenceModel setNumberOfRules(
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public Integer getTimeWindowWidth() {
        return timeWindowWidth;
    }

    public SequenceModel setTimeWindowWidth(
        @org.jpmml.model.annotations.Property("timeWindowWidth")
        Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    public Integer getMinimumTime() {
        return minimumTime;
    }

    public SequenceModel setMinimumTime(
        @org.jpmml.model.annotations.Property("minimumTime")
        Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    public Integer getMaximumTime() {
        return maximumTime;
    }

    public SequenceModel setMaximumTime(
        @org.jpmml.model.annotations.Property("maximumTime")
        Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public SequenceModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public SequenceModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SequenceModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public SequenceModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public SequenceModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public SequenceModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Constraints getConstraints() {
        return constraints;
    }

    public SequenceModel setConstraints(
        @org.jpmml.model.annotations.Property("constraints")
        Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(this.items.size()> 0));
    }

    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    public SequenceModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(this.itemsets.size()> 0));
    }

    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public SequenceModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return ((this.setPredicates!= null)&&(this.setPredicates.size()> 0));
    }

    public List<SetPredicate> getSetPredicates() {
        if (setPredicates == null) {
            setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    public SequenceModel addSetPredicates(SetPredicate... setPredicates) {
        getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return ((this.sequences!= null)&&(this.sequences.size()> 0));
    }

    public List<Sequence> getSequences() {
        if (sequences == null) {
            sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    public SequenceModel addSequences(Sequence... sequences) {
        getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return ((this.sequenceRules!= null)&&(this.sequenceRules.size()> 0));
    }

    public List<SequenceRule> getSequenceRules() {
        if (sequenceRules == null) {
            sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    public SequenceModel addSequenceRules(SequenceRule... sequenceRules) {
        getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getModelStats(), getLocalTransformations(), getConstraints());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, getSetPredicates());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequences()) {
                status = PMMLObject.traverse(visitor, getSequences());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
