
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Time")
@JsonPropertyOrder({
    "min",
    "max",
    "mean",
    "standardDeviation",
    "extensions"
})
public class Time
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Time>
{

    @XmlAttribute(name = "min")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("min")
    private Number min;
    @XmlAttribute(name = "max")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @org.jpmml.model.annotations.Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("max")
    private Number max;
    @XmlAttribute(name = "mean")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "standardDeviation")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("standardDeviation")
    private Number standardDeviation;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371011L;

    public Number getMin() {
        return min;
    }

    public Time setMin(
        @Property("min")
        Number min) {
        this.min = min;
        return this;
    }

    public Number getMax() {
        return max;
    }

    public Time setMax(
        @Property("max")
        Number max) {
        this.max = max;
        return this;
    }

    public Number getMean() {
        return mean;
    }

    public Time setMean(
        @Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number getStandardDeviation() {
        return standardDeviation;
    }

    public Time setStandardDeviation(
        @Property("standardDeviation")
        Number standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Time addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
