
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DynamicRegressor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "numerator",
    "denominator",
    "regressorValues"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("DynamicRegressor")
@JsonPropertyOrder({
    "field",
    "transformation",
    "delay",
    "futureValuesMethod",
    "targetField",
    "extensions",
    "numerator",
    "denominator",
    "regressorValues"
})
public class DynamicRegressor
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DynamicRegressor>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "transformation")
    @JsonProperty("transformation")
    private String transformation;
    @XmlAttribute(name = "delay")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("delay")
    private Integer delay;
    @XmlAttribute(name = "futureValuesMethod")
    @JsonProperty("futureValuesMethod")
    private String futureValuesMethod;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetField")
    private FieldName targetField;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Numerator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Numerator")
    private Numerator numerator;
    @XmlElement(name = "Denominator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Denominator")
    private Denominator denominator;
    @XmlElement(name = "RegressorValues", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("RegressorValues")
    private RegressorValues regressorValues;
    private final static Integer DEFAULT_DELAY = new IntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371011L;

    public DynamicRegressor() {
    }

    @ValueConstructor
    public DynamicRegressor(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return field;
    }

    public DynamicRegressor setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public String getTransformation() {
        if (transformation == null) {
            return "none";
        } else {
            return transformation;
        }
    }

    public DynamicRegressor setTransformation(
        @org.jpmml.model.annotations.Property("transformation")
        String transformation) {
        this.transformation = transformation;
        return this;
    }

    public Integer getDelay() {
        if (delay == null) {
            return DEFAULT_DELAY;
        } else {
            return delay;
        }
    }

    public DynamicRegressor setDelay(
        @org.jpmml.model.annotations.Property("delay")
        Integer delay) {
        this.delay = delay;
        return this;
    }

    public String getFutureValuesMethod() {
        if (futureValuesMethod == null) {
            return "constant";
        } else {
            return futureValuesMethod;
        }
    }

    public DynamicRegressor setFutureValuesMethod(
        @org.jpmml.model.annotations.Property("futureValuesMethod")
        String futureValuesMethod) {
        this.futureValuesMethod = futureValuesMethod;
        return this;
    }

    public FieldName getTargetField() {
        return targetField;
    }

    public DynamicRegressor setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        FieldName targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DynamicRegressor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Numerator getNumerator() {
        return numerator;
    }

    public DynamicRegressor setNumerator(
        @org.jpmml.model.annotations.Property("numerator")
        Numerator numerator) {
        this.numerator = numerator;
        return this;
    }

    public Denominator getDenominator() {
        return denominator;
    }

    public DynamicRegressor setDenominator(
        @org.jpmml.model.annotations.Property("denominator")
        Denominator denominator) {
        this.denominator = denominator;
        return this;
    }

    public RegressorValues getRegressorValues() {
        return regressorValues;
    }

    public DynamicRegressor setRegressorValues(
        @org.jpmml.model.annotations.Property("regressorValues")
        RegressorValues regressorValues) {
        this.regressorValues = regressorValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNumerator(), getDenominator(), getRegressorValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
