
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ChildParent", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
@JsonRootName("ChildParent")
@JsonPropertyOrder({
    "childField",
    "parentField",
    "parentLevelField",
    "recursive",
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
public class ChildParent
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ChildParent> , HasTable<ChildParent>
{

    @XmlAttribute(name = "childField", required = true)
    @JsonProperty("childField")
    private String childField;
    @XmlAttribute(name = "parentField", required = true)
    @JsonProperty("parentField")
    private String parentField;
    @XmlAttribute(name = "parentLevelField")
    @JsonProperty("parentLevelField")
    private String parentLevelField;
    @XmlAttribute(name = "isRecursive")
    @JsonProperty("isRecursive")
    private ChildParent.Recursive recursive;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_4")
    @Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("FieldColumnPair")
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TableLocator")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67371011L;

    public ChildParent() {
    }

    @ValueConstructor
    public ChildParent(
        @org.jpmml.model.annotations.Property("childField")
        String childField,
        @org.jpmml.model.annotations.Property("parentField")
        String parentField,
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.childField = childField;
        this.parentField = parentField;
        this.tableLocator = tableLocator;
        this.inlineTable = inlineTable;
    }

    public String getChildField() {
        return childField;
    }

    public ChildParent setChildField(
        @org.jpmml.model.annotations.Property("childField")
        String childField) {
        this.childField = childField;
        return this;
    }

    public String getParentField() {
        return parentField;
    }

    public ChildParent setParentField(
        @org.jpmml.model.annotations.Property("parentField")
        String parentField) {
        this.parentField = parentField;
        return this;
    }

    public String getParentLevelField() {
        return parentLevelField;
    }

    public ChildParent setParentLevelField(
        @org.jpmml.model.annotations.Property("parentLevelField")
        String parentLevelField) {
        this.parentLevelField = parentLevelField;
        return this;
    }

    public ChildParent.Recursive getRecursive() {
        if (recursive == null) {
            return ChildParent.Recursive.NO;
        } else {
            return recursive;
        }
    }

    public ChildParent setRecursive(
        @org.jpmml.model.annotations.Property("recursive")
        ChildParent.Recursive recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ChildParent addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return ((this.fieldColumnPairs!= null)&&(this.fieldColumnPairs.size()> 0));
    }

    public List<FieldColumnPair> getFieldColumnPairs() {
        if (fieldColumnPairs == null) {
            fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    public ChildParent addFieldColumnPairs(FieldColumnPair... fieldColumnPairs) {
        getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    @Override
    public ChildParent setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    @Override
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    @Override
    public ChildParent setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldColumnPairs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Recursive
        implements StringValue<ChildParent.Recursive>
    {

        @XmlEnumValue("no")
        @JsonProperty("no")
        NO("no"),
        @XmlEnumValue("yes")
        @JsonProperty("yes")
        YES("yes");
        private final String value;

        Recursive(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ChildParent.Recursive fromValue(String v) {
            for (ChildParent.Recursive c: ChildParent.Recursive.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
