
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DataDictionary", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "dataFields",
    "taxonomies"
})
@JsonRootName("DataDictionary")
@JsonPropertyOrder({
    "numberOfFields",
    "extensions",
    "dataFields",
    "taxonomies"
})
public class DataDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DataDictionary>
{

    @XmlAttribute(name = "numberOfFields")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfFields")
    private Integer numberOfFields;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DataField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DataField")
    private List<DataField> dataFields;
    @XmlElement(name = "Taxonomy", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Taxonomy")
    private List<Taxonomy> taxonomies;
    private final static long serialVersionUID = 67371011L;

    public DataDictionary() {
    }

    @ValueConstructor
    public DataDictionary(
        @org.jpmml.model.annotations.Property("dataFields")
        List<DataField> dataFields) {
        this.dataFields = dataFields;
    }

    public Integer getNumberOfFields() {
        return numberOfFields;
    }

    public DataDictionary setNumberOfFields(
        @org.jpmml.model.annotations.Property("numberOfFields")
        Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DataDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDataFields() {
        return ((this.dataFields!= null)&&(this.dataFields.size()> 0));
    }

    public List<DataField> getDataFields() {
        if (dataFields == null) {
            dataFields = new ArrayList<DataField>();
        }
        return this.dataFields;
    }

    public DataDictionary addDataFields(DataField... dataFields) {
        getDataFields().addAll(Arrays.asList(dataFields));
        return this;
    }

    public boolean hasTaxonomies() {
        return ((this.taxonomies!= null)&&(this.taxonomies.size()> 0));
    }

    public List<Taxonomy> getTaxonomies() {
        if (taxonomies == null) {
            taxonomies = new ArrayList<Taxonomy>();
        }
        return this.taxonomies;
    }

    public DataDictionary addTaxonomies(Taxonomy... taxonomies) {
        getTaxonomies().addAll(Arrays.asList(taxonomies));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDataFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDataFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTaxonomies()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTaxonomies());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
