
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Categories", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "categories"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Categories")
@JsonPropertyOrder({
    "extensions",
    "categories"
})
public class Categories
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Category> , HasExtensions<Categories>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Category", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Category")
    private List<Category> categories;
    private final static long serialVersionUID = 67371011L;

    public Categories() {
    }

    @ValueConstructor
    public Categories(
        @Property("categories")
        List<Category> categories) {
        this.categories = categories;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Categories addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Category> iterator() {
        return getCategories().iterator();
    }

    public boolean hasCategories() {
        return ((this.categories!= null)&&(this.categories.size()> 0));
    }

    public List<Category> getCategories() {
        if (categories == null) {
            categories = new ArrayList<Category>();
        }
        return this.categories;
    }

    public Categories addCategories(Category... categories) {
        getCategories().addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCategories()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCategories());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
