
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ARMAPart", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "ar",
    "ma"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("ARMAPart")
@JsonPropertyOrder({
    "constant",
    "p",
    "q",
    "extensions",
    "ar",
    "ma"
})
public class ARMAPart
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ARMAPart>
{

    @XmlAttribute(name = "constant")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("constant")
    private Number constant;
    @XmlAttribute(name = "p", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("p")
    private Integer p;
    @XmlAttribute(name = "q", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("q")
    private Integer q;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AR", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("AR")
    private AR ar;
    @XmlElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MA")
    private MA ma;
    private final static Number DEFAULT_CONSTANT = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371011L;

    public ARMAPart() {
    }

    @ValueConstructor
    public ARMAPart(
        @org.jpmml.model.annotations.Property("p")
        Integer p,
        @org.jpmml.model.annotations.Property("q")
        Integer q,
        @org.jpmml.model.annotations.Property("ar")
        AR ar,
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.p = p;
        this.q = q;
        this.ar = ar;
        this.ma = ma;
    }

    public Number getConstant() {
        if (constant == null) {
            return DEFAULT_CONSTANT;
        } else {
            return constant;
        }
    }

    public ARMAPart setConstant(
        @org.jpmml.model.annotations.Property("constant")
        Number constant) {
        this.constant = constant;
        return this;
    }

    public Integer getP() {
        return p;
    }

    public ARMAPart setP(
        @org.jpmml.model.annotations.Property("p")
        Integer p) {
        this.p = p;
        return this;
    }

    public Integer getQ() {
        return q;
    }

    public ARMAPart setQ(
        @org.jpmml.model.annotations.Property("q")
        Integer q) {
        this.q = q;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARMAPart addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public AR getAR() {
        return ar;
    }

    public ARMAPart setAR(
        @org.jpmml.model.annotations.Property("ar")
        AR ar) {
        this.ar = ar;
        return this;
    }

    public MA getMA() {
        return ma;
    }

    public ARMAPart setMA(
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAR(), getMA());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
