
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "characteristics",
    "modelVerification"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Scorecard")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "initialScore",
    "useReasonCodes",
    "reasonCodeAlgorithm",
    "baselineScore",
    "baselineMethod",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "characteristics",
    "modelVerification"
})
public class Scorecard
    extends Model
    implements HasExtensions<Scorecard>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "initialScore")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("initialScore")
    private Number initialScore;
    @XmlAttribute(name = "useReasonCodes")
    @JsonProperty("useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name = "reasonCodeAlgorithm")
    @JsonProperty("reasonCodeAlgorithm")
    private Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name = "baselineScore")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("baselineScore")
    private Number baselineScore;
    @XmlAttribute(name = "baselineMethod")
    @JsonProperty("baselineMethod")
    private Scorecard.BaselineMethod baselineMethod;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Characteristics", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Characteristics")
    private Characteristics characteristics;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Number DEFAULT_INITIAL_SCORE = new NumberAdapter().unmarshal("0");
    private final static Boolean DEFAULT_USE_REASON_CODES = true;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371265L;

    public Scorecard() {
    }

    @ValueConstructor
    public Scorecard(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("characteristics")
        Characteristics characteristics) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    public String getModelName() {
        return modelName;
    }

    public Scorecard setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public Scorecard setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public Scorecard setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Number getInitialScore() {
        if (initialScore == null) {
            return DEFAULT_INITIAL_SCORE;
        } else {
            return initialScore;
        }
    }

    public Scorecard setInitialScore(
        @org.jpmml.model.annotations.Property("initialScore")
        Number initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    public boolean isUseReasonCodes() {
        if (useReasonCodes == null) {
            return DEFAULT_USE_REASON_CODES;
        } else {
            return useReasonCodes;
        }
    }

    public Scorecard setUseReasonCodes(
        @org.jpmml.model.annotations.Property("useReasonCodes")
        Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    public Scorecard.ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (reasonCodeAlgorithm == null) {
            return Scorecard.ReasonCodeAlgorithm.POINTS_BELOW;
        } else {
            return reasonCodeAlgorithm;
        }
    }

    public Scorecard setReasonCodeAlgorithm(
        @org.jpmml.model.annotations.Property("reasonCodeAlgorithm")
        Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    public Number getBaselineScore() {
        return baselineScore;
    }

    public Scorecard setBaselineScore(
        @org.jpmml.model.annotations.Property("baselineScore")
        Number baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    public Scorecard.BaselineMethod getBaselineMethod() {
        if (baselineMethod == null) {
            return Scorecard.BaselineMethod.OTHER;
        } else {
            return baselineMethod;
        }
    }

    public Scorecard setBaselineMethod(
        @org.jpmml.model.annotations.Property("baselineMethod")
        Scorecard.BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public Scorecard setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public Scorecard setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Scorecard addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public Scorecard setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public Scorecard setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public Scorecard setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public Scorecard setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public Scorecard setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public Scorecard setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Characteristics getCharacteristics() {
        return characteristics;
    }

    public Scorecard setCharacteristics(
        @org.jpmml.model.annotations.Property("characteristics")
        Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public Scorecard setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getCharacteristics(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum BaselineMethod
        implements StringValue<Scorecard.BaselineMethod>
    {

        @XmlEnumValue("max")
        @JsonProperty("max")
        MAX("max"),
        @XmlEnumValue("min")
        @JsonProperty("min")
        MIN("min"),
        @XmlEnumValue("mean")
        @JsonProperty("mean")
        MEAN("mean"),
        @XmlEnumValue("neutral")
        @JsonProperty("neutral")
        NEUTRAL("neutral"),
        @XmlEnumValue("other")
        @JsonProperty("other")
        OTHER("other");
        private final String value;

        BaselineMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Scorecard.BaselineMethod fromValue(String v) {
            for (Scorecard.BaselineMethod c: Scorecard.BaselineMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum ReasonCodeAlgorithm
        implements StringValue<Scorecard.ReasonCodeAlgorithm>
    {

        @XmlEnumValue("pointsAbove")
        @JsonProperty("pointsAbove")
        POINTS_ABOVE("pointsAbove"),
        @XmlEnumValue("pointsBelow")
        @JsonProperty("pointsBelow")
        POINTS_BELOW("pointsBelow");
        private final String value;

        ReasonCodeAlgorithm(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Scorecard.ReasonCodeAlgorithm fromValue(String v) {
            for (Scorecard.ReasonCodeAlgorithm c: Scorecard.ReasonCodeAlgorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
