
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "coefficients"
})
@JsonRootName("Coefficients")
@JsonPropertyOrder({
    "numberOfCoefficients",
    "absoluteValue",
    "extensions",
    "coefficients"
})
public class Coefficients
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Coefficient> , HasExtensions<Coefficients>
{

    @XmlAttribute(name = "numberOfCoefficients")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfCoefficients")
    private Integer numberOfCoefficients;
    @XmlAttribute(name = "absoluteValue")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("absoluteValue")
    private Number absoluteValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Coefficient", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Coefficient")
    private List<Coefficient> coefficients;
    private final static Number DEFAULT_ABSOLUTE_VALUE = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371265L;

    public Coefficients() {
    }

    @ValueConstructor
    public Coefficients(
        @org.jpmml.model.annotations.Property("coefficients")
        List<Coefficient> coefficients) {
        this.coefficients = coefficients;
    }

    public Integer getNumberOfCoefficients() {
        return numberOfCoefficients;
    }

    public Coefficients setNumberOfCoefficients(
        @org.jpmml.model.annotations.Property("numberOfCoefficients")
        Integer numberOfCoefficients) {
        this.numberOfCoefficients = numberOfCoefficients;
        return this;
    }

    public Number getAbsoluteValue() {
        if (absoluteValue == null) {
            return DEFAULT_ABSOLUTE_VALUE;
        } else {
            return absoluteValue;
        }
    }

    public Coefficients setAbsoluteValue(
        @org.jpmml.model.annotations.Property("absoluteValue")
        Number absoluteValue) {
        this.absoluteValue = absoluteValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Coefficients addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Coefficient> iterator() {
        return getCoefficients().iterator();
    }

    public boolean hasCoefficients() {
        return ((this.coefficients!= null)&&(this.coefficients.size()> 0));
    }

    public List<Coefficient> getCoefficients() {
        if (coefficients == null) {
            coefficients = new ArrayList<Coefficient>();
        }
        return this.coefficients;
    }

    public Coefficients addCoefficients(Coefficient... coefficients) {
        getCoefficients().addAll(Arrays.asList(coefficients));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCoefficients()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
