
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Array;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "array"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("TimeException")
@JsonPropertyOrder({
    "type",
    "count",
    "array"
})
public class TimeException
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "type")
    @JsonProperty("type")
    private TimeException.Type type;
    @XmlAttribute(name = "count")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("count")
    private Integer count;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    private final static long serialVersionUID = 67371265L;

    public TimeException() {
    }

    @ValueConstructor
    public TimeException(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
    }

    public TimeException.Type getType() {
        return type;
    }

    public TimeException setType(
        @org.jpmml.model.annotations.Property("type")
        TimeException.Type type) {
        this.type = type;
        return this;
    }

    public Integer getCount() {
        return count;
    }

    public TimeException setCount(
        @org.jpmml.model.annotations.Property("count")
        Integer count) {
        this.count = count;
        return this;
    }

    public Array getArray() {
        return array;
    }

    public TimeException setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<TimeException.Type>
    {

        @XmlEnumValue("exclude")
        @JsonProperty("exclude")
        EXCLUDE("exclude"),
        @XmlEnumValue("include")
        @JsonProperty("include")
        INCLUDE("include");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TimeException.Type fromValue(String v) {
            for (TimeException.Type c: TimeException.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
