
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("AnyDistribution")
@JsonPropertyOrder({
    "mean",
    "variance",
    "extensions"
})
public class AnyDistribution
    extends ContinuousDistribution
    implements HasExtensions<AnyDistribution>
{

    @XmlAttribute(name = "mean", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "variance", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("variance")
    private Number variance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371265L;

    public AnyDistribution() {
    }

    @ValueConstructor
    public AnyDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Number mean,
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public Number getMean() {
        return mean;
    }

    public AnyDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number getVariance() {
        return variance;
    }

    public AnyDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AnyDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
