
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.HasDisplayName;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "TimeAnchor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "timeCycles",
    "timeExceptions"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("TimeAnchor")
@JsonPropertyOrder({
    "type",
    "offset",
    "stepsize",
    "displayName",
    "timeCycles",
    "timeExceptions"
})
public class TimeAnchor
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayName<TimeAnchor>
{

    @XmlAttribute(name = "type")
    @JsonProperty("type")
    private TimeAnchor.Type type;
    @XmlAttribute(name = "offset")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("offset")
    private Integer offset;
    @XmlAttribute(name = "stepsize")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("stepsize")
    private Integer stepsize;
    @XmlAttribute(name = "displayName")
    @JsonProperty("displayName")
    private String displayName;
    @XmlElement(name = "TimeCycle", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TimeCycle")
    private List<TimeCycle> timeCycles;
    @XmlElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TimeException")
    private List<TimeException> timeExceptions;
    private final static long serialVersionUID = 67371265L;

    public TimeAnchor.Type getType() {
        return type;
    }

    public TimeAnchor setType(
        @Property("type")
        TimeAnchor.Type type) {
        this.type = type;
        return this;
    }

    public Integer getOffset() {
        return offset;
    }

    public TimeAnchor setOffset(
        @Property("offset")
        Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getStepsize() {
        return stepsize;
    }

    public TimeAnchor setStepsize(
        @Property("stepsize")
        Integer stepsize) {
        this.stepsize = stepsize;
        return this;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public TimeAnchor setDisplayName(
        @Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean hasTimeCycles() {
        return ((this.timeCycles!= null)&&(this.timeCycles.size()> 0));
    }

    public List<TimeCycle> getTimeCycles() {
        if (timeCycles == null) {
            timeCycles = new ArrayList<TimeCycle>();
        }
        return this.timeCycles;
    }

    public TimeAnchor addTimeCycles(TimeCycle... timeCycles) {
        getTimeCycles().addAll(Arrays.asList(timeCycles));
        return this;
    }

    public boolean hasTimeExceptions() {
        return ((this.timeExceptions!= null)&&(this.timeExceptions.size()> 0));
    }

    public List<TimeException> getTimeExceptions() {
        if (timeExceptions == null) {
            timeExceptions = new ArrayList<TimeException>();
        }
        return this.timeExceptions;
    }

    public TimeAnchor addTimeExceptions(TimeException... timeExceptions) {
        getTimeExceptions().addAll(Arrays.asList(timeExceptions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasTimeCycles()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeCycles());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeExceptions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeExceptions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<TimeAnchor.Type>
    {

        @XmlEnumValue("dateTimeMillisecondsSince[0]")
        @JsonProperty("dateTimeMillisecondsSince[0]")
        DATE_TIME_MILLISECONDS_SINCE_0("dateTimeMillisecondsSince[0]"),
        @XmlEnumValue("dateTimeMillisecondsSince[1960]")
        @JsonProperty("dateTimeMillisecondsSince[1960]")
        DATE_TIME_MILLISECONDS_SINCE_1960("dateTimeMillisecondsSince[1960]"),
        @XmlEnumValue("dateTimeMillisecondsSince[1970]")
        @JsonProperty("dateTimeMillisecondsSince[1970]")
        DATE_TIME_MILLISECONDS_SINCE_1970("dateTimeMillisecondsSince[1970]"),
        @XmlEnumValue("dateTimeMillisecondsSince[1980]")
        @JsonProperty("dateTimeMillisecondsSince[1980]")
        DATE_TIME_MILLISECONDS_SINCE_1980("dateTimeMillisecondsSince[1980]"),
        @XmlEnumValue("dateTimeSecondsSince[0]")
        @JsonProperty("dateTimeSecondsSince[0]")
        DATE_TIME_SECONDS_SINCE_0("dateTimeSecondsSince[0]"),
        @XmlEnumValue("dateTimeSecondsSince[1960]")
        @JsonProperty("dateTimeSecondsSince[1960]")
        DATE_TIME_SECONDS_SINCE_1960("dateTimeSecondsSince[1960]"),
        @XmlEnumValue("dateTimeSecondsSince[1970]")
        @JsonProperty("dateTimeSecondsSince[1970]")
        DATE_TIME_SECONDS_SINCE_1970("dateTimeSecondsSince[1970]"),
        @XmlEnumValue("dateTimeSecondsSince[1980]")
        @JsonProperty("dateTimeSecondsSince[1980]")
        DATE_TIME_SECONDS_SINCE_1980("dateTimeSecondsSince[1980]"),
        @XmlEnumValue("dateDaysSince[0]")
        @JsonProperty("dateDaysSince[0]")
        DATE_DAYS_SINCE_0("dateDaysSince[0]"),
        @XmlEnumValue("dateDaysSince[1960]")
        @JsonProperty("dateDaysSince[1960]")
        DATE_DAYS_SINCE_1960("dateDaysSince[1960]"),
        @XmlEnumValue("dateDaysSince[1970]")
        @JsonProperty("dateDaysSince[1970]")
        DATE_DAYS_SINCE_1970("dateDaysSince[1970]"),
        @XmlEnumValue("dateDaysSince[1980]")
        @JsonProperty("dateDaysSince[1980]")
        DATE_DAYS_SINCE_1980("dateDaysSince[1980]"),
        @XmlEnumValue("dateMonthsSince[0]")
        @JsonProperty("dateMonthsSince[0]")
        DATE_MONTHS_SINCE_0("dateMonthsSince[0]"),
        @XmlEnumValue("dateMonthsSince[1960]")
        @JsonProperty("dateMonthsSince[1960]")
        DATE_MONTHS_SINCE_1960("dateMonthsSince[1960]"),
        @XmlEnumValue("dateMonthsSince[1970]")
        @JsonProperty("dateMonthsSince[1970]")
        DATE_MONTHS_SINCE_1970("dateMonthsSince[1970]"),
        @XmlEnumValue("dateMonthsSince[1980]")
        @JsonProperty("dateMonthsSince[1980]")
        DATE_MONTHS_SINCE_1980("dateMonthsSince[1980]"),
        @XmlEnumValue("dateYearsSince[0]")
        @JsonProperty("dateYearsSince[0]")
        DATE_YEARS_SINCE_0("dateYearsSince[0]");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TimeAnchor.Type fromValue(String v) {
            for (TimeAnchor.Type c: TimeAnchor.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
