
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("MiningField")
@JsonPropertyOrder({
    "name",
    "usageType",
    "opType",
    "importance",
    "outlierTreatment",
    "lowValue",
    "highValue",
    "missingValueReplacement",
    "missingValueTreatment",
    "invalidValueTreatment",
    "invalidValueReplacement",
    "extensions"
})
public class MiningField
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MiningField> , HasOpType<MiningField> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private org.dmg.pmml.FieldName name;
    @XmlAttribute(name = "usageType")
    @JsonProperty("usageType")
    private MiningField.UsageType usageType;
    @XmlAttribute(name = "optype")
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "importance")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("importance")
    private Number importance;
    @XmlAttribute(name = "outliers")
    @JsonProperty("outliers")
    private OutlierTreatmentMethod outlierTreatment;
    @XmlAttribute(name = "lowValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("lowValue")
    private Number lowValue;
    @XmlAttribute(name = "highValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("highValue")
    private Number highValue;
    @XmlAttribute(name = "missingValueReplacement")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("missingValueReplacement")
    private Object missingValueReplacement;
    @XmlAttribute(name = "missingValueTreatment")
    @JsonProperty("missingValueTreatment")
    private MissingValueTreatmentMethod missingValueTreatment;
    @XmlAttribute(name = "invalidValueTreatment")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("invalidValueTreatment")
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlAttribute(name = "invalidValueReplacement")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("invalidValueReplacement")
    private Object invalidValueReplacement;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371265L;

    public MiningField() {
    }

    @ValueConstructor
    public MiningField(
        @org.jpmml.model.annotations.Property("name")
        org.dmg.pmml.FieldName name) {
        this.name = name;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getName();
    }

    public org.dmg.pmml.FieldName getName() {
        return name;
    }

    public MiningField setName(
        @org.jpmml.model.annotations.Property("name")
        org.dmg.pmml.FieldName name) {
        this.name = name;
        return this;
    }

    public MiningField.UsageType getUsageType() {
        if (usageType == null) {
            return MiningField.UsageType.ACTIVE;
        } else {
            return usageType;
        }
    }

    public MiningField setUsageType(
        @org.jpmml.model.annotations.Property("usageType")
        MiningField.UsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public MiningField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public Number getImportance() {
        return importance;
    }

    public MiningField setImportance(
        @org.jpmml.model.annotations.Property("importance")
        Number importance) {
        this.importance = importance;
        return this;
    }

    public OutlierTreatmentMethod getOutlierTreatment() {
        if (outlierTreatment == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outlierTreatment;
        }
    }

    public MiningField setOutlierTreatment(
        @org.jpmml.model.annotations.Property("outlierTreatment")
        OutlierTreatmentMethod outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    public Number getLowValue() {
        return lowValue;
    }

    public MiningField setLowValue(
        @org.jpmml.model.annotations.Property("lowValue")
        Number lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    public Number getHighValue() {
        return highValue;
    }

    public MiningField setHighValue(
        @org.jpmml.model.annotations.Property("highValue")
        Number highValue) {
        this.highValue = highValue;
        return this;
    }

    public Object getMissingValueReplacement() {
        return missingValueReplacement;
    }

    public MiningField setMissingValueReplacement(
        @org.jpmml.model.annotations.Property("missingValueReplacement")
        Object missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
        return this;
    }

    public MissingValueTreatmentMethod getMissingValueTreatment() {
        return missingValueTreatment;
    }

    public MiningField setMissingValueTreatment(
        @org.jpmml.model.annotations.Property("missingValueTreatment")
        MissingValueTreatmentMethod missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
        return this;
    }

    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    public MiningField setInvalidValueTreatment(
        @org.jpmml.model.annotations.Property("invalidValueTreatment")
        InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    public Object getInvalidValueReplacement() {
        return invalidValueReplacement;
    }

    public MiningField setInvalidValueReplacement(
        @org.jpmml.model.annotations.Property("invalidValueReplacement")
        Object invalidValueReplacement) {
        this.invalidValueReplacement = invalidValueReplacement;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum UsageType
        implements StringValue<MiningField.UsageType>
    {

        @XmlEnumValue("active")
        @JsonProperty("active")
        ACTIVE("active"),
        @XmlEnumValue("predicted")
        @Deprecated((org.dmg.pmml.Version.PMML_4_2))
        @JsonProperty("predicted")
        PREDICTED("predicted"),
        @XmlEnumValue("target")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
        @JsonProperty("target")
        TARGET("target"),
        @XmlEnumValue("supplementary")
        @JsonProperty("supplementary")
        SUPPLEMENTARY("supplementary"),
        @XmlEnumValue("group")
        @JsonProperty("group")
        GROUP("group"),
        @XmlEnumValue("order")
        @JsonProperty("order")
        ORDER("order"),
        @XmlEnumValue("frequencyWeight")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        @JsonProperty("frequencyWeight")
        FREQUENCY_WEIGHT("frequencyWeight"),
        @XmlEnumValue("analysisWeight")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
        @JsonProperty("analysisWeight")
        ANALYSIS_WEIGHT("analysisWeight");
        private final String value;

        UsageType(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static MiningField.UsageType fromValue(String v) {
            for (MiningField.UsageType c: MiningField.UsageType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
