
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ROCGraph", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ROCGraph")
@JsonPropertyOrder({
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues"
})
public class ROCGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ROCGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "XCoordinates", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("XCoordinates")
    private XCoordinates xCoordinates;
    @XmlElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("YCoordinates")
    private YCoordinates yCoordinates;
    @XmlElement(name = "BoundaryValues", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BoundaryValues")
    private BoundaryValues boundaryValues;
    private final static long serialVersionUID = 67371265L;

    public ROCGraph() {
    }

    @ValueConstructor
    public ROCGraph(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates,
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.xCoordinates = xCoordinates;
        this.yCoordinates = yCoordinates;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ROCGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public XCoordinates getXCoordinates() {
        return xCoordinates;
    }

    public ROCGraph setXCoordinates(
        @org.jpmml.model.annotations.Property("xCoordinates")
        XCoordinates xCoordinates) {
        this.xCoordinates = xCoordinates;
        return this;
    }

    public YCoordinates getYCoordinates() {
        return yCoordinates;
    }

    public ROCGraph setYCoordinates(
        @org.jpmml.model.annotations.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.yCoordinates = yCoordinates;
        return this;
    }

    public BoundaryValues getBoundaryValues() {
        return boundaryValues;
    }

    public ROCGraph setBoundaryValues(
        @org.jpmml.model.annotations.Property("boundaryValues")
        BoundaryValues boundaryValues) {
        this.boundaryValues = boundaryValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getXCoordinates(), getYCoordinates(), getBoundaryValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
