
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TextIndexNormalization", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "tableLocator",
    "inlineTable"
})
@Added((org.dmg.pmml.Version.PMML_4_2))
@JsonRootName("TextIndexNormalization")
@JsonPropertyOrder({
    "inField",
    "outField",
    "regexField",
    "recursive",
    "caseSensitive",
    "maxLevenshteinDistance",
    "wordSeparatorCharacterRE",
    "tokenize",
    "extensions",
    "tableLocator",
    "inlineTable"
})
public class TextIndexNormalization
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TextIndexNormalization> , HasTable<TextIndexNormalization>
{

    @XmlAttribute(name = "inField")
    @JsonProperty("inField")
    private String inField;
    @XmlAttribute(name = "outField")
    @JsonProperty("outField")
    private String outField;
    @XmlAttribute(name = "regexField")
    @JsonProperty("regexField")
    private String regexField;
    @XmlAttribute(name = "recursive")
    @JsonProperty("recursive")
    private Boolean recursive;
    @XmlAttribute(name = "isCaseSensitive")
    @JsonProperty("isCaseSensitive")
    private Boolean caseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    @JsonProperty("wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name = "tokenize")
    @JsonProperty("tokenize")
    private Boolean tokenize;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TableLocator")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static Boolean DEFAULT_RECURSIVE = false;
    private final static long serialVersionUID = 67371265L;

    public TextIndexNormalization() {
    }

    @ValueConstructor
    public TextIndexNormalization(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.tableLocator = tableLocator;
        this.inlineTable = inlineTable;
    }

    public String getInField() {
        if (inField == null) {
            return "string";
        } else {
            return inField;
        }
    }

    public TextIndexNormalization setInField(
        @org.jpmml.model.annotations.Property("inField")
        String inField) {
        this.inField = inField;
        return this;
    }

    public String getOutField() {
        if (outField == null) {
            return "stem";
        } else {
            return outField;
        }
    }

    public TextIndexNormalization setOutField(
        @org.jpmml.model.annotations.Property("outField")
        String outField) {
        this.outField = outField;
        return this;
    }

    public String getRegexField() {
        if (regexField == null) {
            return "regex";
        } else {
            return regexField;
        }
    }

    public TextIndexNormalization setRegexField(
        @org.jpmml.model.annotations.Property("regexField")
        String regexField) {
        this.regexField = regexField;
        return this;
    }

    public boolean isRecursive() {
        if (recursive == null) {
            return DEFAULT_RECURSIVE;
        } else {
            return recursive;
        }
    }

    public TextIndexNormalization setRecursive(
        @org.jpmml.model.annotations.Property("recursive")
        Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public Boolean isCaseSensitive() {
        return caseSensitive;
    }

    public TextIndexNormalization setCaseSensitive(
        @org.jpmml.model.annotations.Property("caseSensitive")
        Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Integer getMaxLevenshteinDistance() {
        return maxLevenshteinDistance;
    }

    public TextIndexNormalization setMaxLevenshteinDistance(
        @org.jpmml.model.annotations.Property("maxLevenshteinDistance")
        Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        return wordSeparatorCharacterRE;
    }

    public TextIndexNormalization setWordSeparatorCharacterRE(
        @org.jpmml.model.annotations.Property("wordSeparatorCharacterRE")
        String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public Boolean isTokenize() {
        return tokenize;
    }

    public TextIndexNormalization setTokenize(
        @org.jpmml.model.annotations.Property("tokenize")
        Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextIndexNormalization addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    @Override
    public TextIndexNormalization setTableLocator(
        @org.jpmml.model.annotations.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    @Override
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    @Override
    public TextIndexNormalization setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
