
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;

@XmlRootElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedFields"
})
@JsonRootName("LocalTransformations")
@JsonPropertyOrder({
    "extensions",
    "derivedFields"
})
public class LocalTransformations
    extends org.dmg.pmml.PMMLObject
    implements HasDerivedFields<LocalTransformations> , HasExtensions<LocalTransformations>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DerivedField")
    private List<DerivedField> derivedFields;
    private final static long serialVersionUID = 67371269L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public LocalTransformations addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(this.derivedFields.size()> 0));
    }

    @Override
    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    @Override
    public LocalTransformations addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
