
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DataField", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "intervals",
    "values"
})
@JsonRootName("DataField")
@JsonPropertyOrder({
    "name",
    "displayName",
    "opType",
    "dataType",
    "taxonomy",
    "cyclic",
    "extensions",
    "intervals",
    "values"
})
public class DataField
    extends Field<DataField>
    implements Decorable, HasContinuousDomain<DataField> , HasDiscreteDomain<DataField> , HasExtensions<DataField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "displayName")
    @JsonProperty("displayName")
    private String displayName;
    @XmlAttribute(name = "optype", required = true)
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "dataType", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlAttribute(name = "taxonomy")
    @JsonProperty("taxonomy")
    private String taxonomy;
    @XmlAttribute(name = "isCyclic")
    @JsonProperty("isCyclic")
    private DataField.Cyclic cyclic;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Interval")
    private List<Interval> intervals;
    @XmlElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Value")
    private List<Value> values;
    private final static long serialVersionUID = 67371269L;

    public DataField() {
    }

    @ValueConstructor
    public DataField(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("opType")
        OpType opType,
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public DataField setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getDisplayName() {
        return displayName;
    }

    public DataField setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public DataField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public DataField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getTaxonomy() {
        return taxonomy;
    }

    public DataField setTaxonomy(
        @org.jpmml.model.annotations.Property("taxonomy")
        String taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public DataField.Cyclic getCyclic() {
        if (cyclic == null) {
            return DataField.Cyclic.ZERO;
        } else {
            return cyclic;
        }
    }

    public DataField setCyclic(
        @org.jpmml.model.annotations.Property("cyclic")
        DataField.Cyclic cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DataField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public boolean hasIntervals() {
        return ((this.intervals!= null)&&(this.intervals.size()> 0));
    }

    @Override
    public List<Interval> getIntervals() {
        if (intervals == null) {
            intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    @Override
    public DataField addIntervals(Interval... intervals) {
        getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    @Override
    public boolean hasValues() {
        return ((this.values!= null)&&(this.values.size()> 0));
    }

    @Override
    public List<Value> getValues() {
        if (values == null) {
            values = new ArrayList<Value>();
        }
        return this.values;
    }

    @Override
    public DataField addValues(Value... values) {
        getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasIntervals()) {
                status = PMMLObject.traverse(visitor, getIntervals());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValues()) {
                status = PMMLObject.traverse(visitor, getValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Cyclic
        implements StringValue<DataField.Cyclic>
    {

        @XmlEnumValue("0")
        @JsonProperty("0")
        ZERO("0"),
        @XmlEnumValue("1")
        @JsonProperty("1")
        ONE("1");
        private final String value;

        Cyclic(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DataField.Cyclic fromValue(String v) {
            for (DataField.Cyclic c: DataField.Cyclic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
