
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DiscreteDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlType(name = "COUNT-TABLE-TYPE", namespace = "http://www.dmg.org/PMML-4_4", propOrder = {
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonPropertyOrder({
    "sample",
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
public class CountTable
    extends DiscreteDistribution
    implements HasExtensions<CountTable>
{

    @XmlAttribute(name = "sample")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("sample")
    private Number sample;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldValue", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FieldValue")
    private List<FieldValue> fieldValues;
    @XmlElement(name = "FieldValueCount", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FieldValueCount")
    private List<FieldValueCount> fieldValueCounts;
    private final static long serialVersionUID = 67371269L;

    public CountTable() {
    }

    @ValueConstructor
    public CountTable(
        @org.jpmml.model.annotations.Property("fieldValues")
        List<FieldValue> fieldValues,
        @org.jpmml.model.annotations.Property("fieldValueCounts")
        List<FieldValueCount> fieldValueCounts) {
        this.fieldValues = fieldValues;
        this.fieldValueCounts = fieldValueCounts;
    }

    public Number getSample() {
        return sample;
    }

    public CountTable setSample(
        @org.jpmml.model.annotations.Property("sample")
        Number sample) {
        this.sample = sample;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public CountTable addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldValues() {
        return ((this.fieldValues!= null)&&(this.fieldValues.size()> 0));
    }

    public List<FieldValue> getFieldValues() {
        if (fieldValues == null) {
            fieldValues = new ArrayList<FieldValue>();
        }
        return this.fieldValues;
    }

    public CountTable addFieldValues(FieldValue... fieldValues) {
        getFieldValues().addAll(Arrays.asList(fieldValues));
        return this;
    }

    public boolean hasFieldValueCounts() {
        return ((this.fieldValueCounts!= null)&&(this.fieldValueCounts.size()> 0));
    }

    public List<FieldValueCount> getFieldValueCounts() {
        if (fieldValueCounts == null) {
            fieldValueCounts = new ArrayList<FieldValueCount>();
        }
        return this.fieldValueCounts;
    }

    public CountTable addFieldValueCounts(FieldValueCount... fieldValueCounts) {
        getFieldValueCounts().addAll(Arrays.asList(fieldValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValues()) {
                status = PMMLObject.traverse(visitor, getFieldValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValueCounts()) {
                status = PMMLObject.traverse(visitor, getFieldValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
