
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Optional;

@XmlRootElement(name = "ParamMatrix", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "pCells"
})
@JsonRootName("ParamMatrix")
@JsonPropertyOrder({
    "extensions",
    "pCells"
})
public class ParamMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ParamMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "PCell", namespace = "http://www.dmg.org/PMML-4_4")
    @Optional((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("PCell")
    private List<PCell> pCells;
    private final static long serialVersionUID = 67371269L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ParamMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPCells() {
        return ((this.pCells!= null)&&(this.pCells.size()> 0));
    }

    public List<PCell> getPCells() {
        if (pCells == null) {
            pCells = new ArrayList<PCell>();
        }
        return this.pCells;
    }

    public ParamMatrix addPCells(PCell... pCells) {
        getPCells().addAll(Arrays.asList(pCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
