
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TargetValueCounts", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueCounts"
})
@JsonRootName("TargetValueCounts")
@JsonPropertyOrder({
    "extensions",
    "targetValueCounts"
})
public class TargetValueCounts
    extends org.dmg.pmml.PMMLObject
    implements Iterable<TargetValueCount> , HasExtensions<TargetValueCounts>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueCount", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TargetValueCount")
    private List<TargetValueCount> targetValueCounts;
    private final static long serialVersionUID = 67371269L;

    public TargetValueCounts() {
    }

    @ValueConstructor
    public TargetValueCounts(
        @Property("targetValueCounts")
        List<TargetValueCount> targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TargetValueCounts addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<TargetValueCount> iterator() {
        return getTargetValueCounts().iterator();
    }

    public boolean hasTargetValueCounts() {
        return ((this.targetValueCounts!= null)&&(this.targetValueCounts.size()> 0));
    }

    public List<TargetValueCount> getTargetValueCounts() {
        if (targetValueCounts == null) {
            targetValueCounts = new ArrayList<TargetValueCount>();
        }
        return this.targetValueCounts;
    }

    public TargetValueCounts addTargetValueCounts(TargetValueCount... targetValueCounts) {
        getTargetValueCounts().addAll(Arrays.asList(targetValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValueCounts()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
