
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Characteristic", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "attributes"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Characteristic")
@JsonPropertyOrder({
    "name",
    "reasonCode",
    "baselineScore",
    "extensions",
    "attributes"
})
public class Characteristic
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Characteristic> , HasBaselineScore<Characteristic> , HasReasonCode<Characteristic>
{

    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "reasonCode")
    @JsonProperty("reasonCode")
    private String reasonCode;
    @XmlAttribute(name = "baselineScore")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("baselineScore")
    private Number baselineScore;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Attribute", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Attribute")
    private List<Attribute> attributes;
    private final static long serialVersionUID = 67371269L;

    public Characteristic() {
    }

    @ValueConstructor
    public Characteristic(
        @org.jpmml.model.annotations.Property("attributes")
        List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public String getName() {
        return name;
    }

    public Characteristic setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getReasonCode() {
        return reasonCode;
    }

    @Override
    public Characteristic setReasonCode(
        @org.jpmml.model.annotations.Property("reasonCode")
        String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Override
    public Number getBaselineScore() {
        return baselineScore;
    }

    @Override
    public Characteristic setBaselineScore(
        @org.jpmml.model.annotations.Property("baselineScore")
        Number baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Characteristic addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasAttributes() {
        return ((this.attributes!= null)&&(this.attributes.size()> 0));
    }

    public List<Attribute> getAttributes() {
        if (attributes == null) {
            attributes = new ArrayList<Attribute>();
        }
        return this.attributes;
    }

    public Characteristic addAttributes(Attribute... attributes) {
        getAttributes().addAll(Arrays.asList(attributes));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAttributes()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAttributes());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
