
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name = "MINING-FUNCTION", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum MiningFunction
    implements StringValue<MiningFunction>
{

    @XmlEnumValue("associationRules")
    @JsonProperty("associationRules")
    ASSOCIATION_RULES("associationRules"),
    @XmlEnumValue("sequences")
    @JsonProperty("sequences")
    SEQUENCES("sequences"),
    @XmlEnumValue("classification")
    @JsonProperty("classification")
    CLASSIFICATION("classification"),
    @XmlEnumValue("regression")
    @JsonProperty("regression")
    REGRESSION("regression"),
    @XmlEnumValue("clustering")
    @JsonProperty("clustering")
    CLUSTERING("clustering"),
    @XmlEnumValue("timeSeries")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("timeSeries")
    TIME_SERIES("timeSeries"),
    @XmlEnumValue("mixed")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("mixed")
    MIXED("mixed");
    private final String value;

    MiningFunction(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static MiningFunction fromValue(String v) {
        for (MiningFunction c: MiningFunction.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
