
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.regression.RegressionModel.NormalizationMethod;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "regressionTables"
})
@Deprecated((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Regression")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "normalizationMethod",
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "regressionTables"
})
public class Regression
    extends EmbeddedModel
    implements HasExtensions<Regression> , HasRegressionTables<Regression>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "normalizationMethod")
    @JsonProperty("normalizationMethod")
    private NormalizationMethod normalizationMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ResultField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ResultField")
    private List<ResultField> resultFields;
    @XmlElement(name = "RegressionTable", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("RegressionTable")
    private List<RegressionTable> regressionTables;
    private final static long serialVersionUID = 67371269L;

    public Regression() {
    }

    @ValueConstructor
    public Regression(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("regressionTables")
        List<RegressionTable> regressionTables) {
        this.miningFunction = miningFunction;
        this.regressionTables = regressionTables;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public Regression setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.REGRESSION_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public Regression setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public Regression setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    @Override
    public Regression setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Regression addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public Regression setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public Regression setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public Regression setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public Regression setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasResultFields() {
        return ((this.resultFields!= null)&&(!this.resultFields.isEmpty()));
    }

    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public Regression addResultFields(ResultField... resultFields) {
        getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    @Override
    public boolean hasRegressionTables() {
        return ((this.regressionTables!= null)&&(!this.regressionTables.isEmpty()));
    }

    public List<RegressionTable> requireRegressionTables() {
        if ((this.regressionTables == null)||this.regressionTables.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.REGRESSION_REGRESSIONTABLES);
        }
        return this.regressionTables;
    }

    @Override
    public List<RegressionTable> getRegressionTables() {
        if (regressionTables == null) {
            regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    @Override
    public Regression addRegressionTables(RegressionTable... regressionTables) {
        getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getOutput(), getModelStats(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasResultFields()) {
                status = PMMLObject.traverse(visitor, getResultFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRegressionTables()) {
                status = PMMLObject.traverse(visitor, getRegressionTables());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
