
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "content"
})
@JsonRootName("Extension")
@JsonPropertyOrder({
    "extender",
    "name",
    "value",
    "content"
})
public class Extension
    extends org.dmg.pmml.PMMLObject
    implements HasMixedContent<Extension>
{

    @XmlAttribute(name = "extender")
    @JsonProperty("extender")
    private String extender;
    @XmlAttribute(name = "name")
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "value")
    @JsonProperty("value")
    private String value;
    @XmlMixed
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private final static long serialVersionUID = 67371269L;

    public String getExtender() {
        return extender;
    }

    public Extension setExtender(
        @Property("extender")
        String extender) {
        this.extender = extender;
        return this;
    }

    public String getName() {
        return name;
    }

    public Extension setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Extension setValue(
        @Property("value")
        String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    @Override
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    @Override
    public Extension addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
