
package org.dmg.pmml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
@Deprecated((org.dmg.pmml.Version.PMML_4_2))
@JsonRootName("TextModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfTerms",
    "numberOfDocuments",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
public class TextModel
    extends Model
    implements HasExtensions<TextModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTerms", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfTerms")
    private Integer numberOfTerms;
    @XmlAttribute(name = "numberOfDocuments", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfDocuments")
    private Integer numberOfDocuments;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TextDictionary", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TextDictionary")
    private TextDictionary textDictionary;
    @XmlElement(name = "TextCorpus", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TextCorpus")
    private TextCorpus textCorpus;
    @XmlElement(name = "DocumentTermMatrix", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DocumentTermMatrix")
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TextModelNormalization")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name = "TextModelSimiliarity", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TextModelSimiliarity")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371269L;

    public TextModel() {
    }

    @ValueConstructor
    public TextModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("numberOfTerms")
        Integer numberOfTerms,
        @org.jpmml.model.annotations.Property("numberOfDocuments")
        Integer numberOfDocuments,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("textDictionary")
        TextDictionary textDictionary,
        @org.jpmml.model.annotations.Property("textCorpus")
        TextCorpus textCorpus,
        @org.jpmml.model.annotations.Property("documentTermMatrix")
        DocumentTermMatrix documentTermMatrix) {
        this.miningFunction = miningFunction;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public TextModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public TextModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public TextModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer requireNumberOfTerms() {
        if (this.numberOfTerms == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_NUMBEROFTERMS);
        }
        return this.numberOfTerms;
    }

    public Integer getNumberOfTerms() {
        return numberOfTerms;
    }

    public TextModel setNumberOfTerms(
        @org.jpmml.model.annotations.Property("numberOfTerms")
        Integer numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    public Integer requireNumberOfDocuments() {
        if (this.numberOfDocuments == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_NUMBEROFDOCUMENTS);
        }
        return this.numberOfDocuments;
    }

    public Integer getNumberOfDocuments() {
        return numberOfDocuments;
    }

    public TextModel setNumberOfDocuments(
        @org.jpmml.model.annotations.Property("numberOfDocuments")
        Integer numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public TextModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public TextModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public TextModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public TextModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public TextModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public TextModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public TextModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public TextModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TextDictionary requireTextDictionary() {
        if (this.textDictionary == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_TEXTDICTIONARY);
        }
        return this.textDictionary;
    }

    public TextDictionary getTextDictionary() {
        return textDictionary;
    }

    public TextModel setTextDictionary(
        @org.jpmml.model.annotations.Property("textDictionary")
        TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    public TextCorpus requireTextCorpus() {
        if (this.textCorpus == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_TEXTCORPUS);
        }
        return this.textCorpus;
    }

    public TextCorpus getTextCorpus() {
        return textCorpus;
    }

    public TextModel setTextCorpus(
        @org.jpmml.model.annotations.Property("textCorpus")
        TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    public DocumentTermMatrix requireDocumentTermMatrix() {
        if (this.documentTermMatrix == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_DOCUMENTTERMMATRIX);
        }
        return this.documentTermMatrix;
    }

    public DocumentTermMatrix getDocumentTermMatrix() {
        return documentTermMatrix;
    }

    public TextModel setDocumentTermMatrix(
        @org.jpmml.model.annotations.Property("documentTermMatrix")
        DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    public TextModelNormalization getTextModelNormalization() {
        return textModelNormalization;
    }

    public TextModel setTextModelNormalization(
        @org.jpmml.model.annotations.Property("textModelNormalization")
        TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    public TextModelSimiliarity getTextModelSimiliarity() {
        return textModelSimiliarity;
    }

    public TextModel setTextModelSimiliarity(
        @org.jpmml.model.annotations.Property("textModelSimiliarity")
        TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public TextModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTextDictionary(), getTextCorpus(), getDocumentTermMatrix(), getTextModelNormalization(), getTextModelSimiliarity(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
