
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "OutlierEffect", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("OutlierEffect")
@JsonPropertyOrder({
    "type",
    "startTime",
    "magnitude",
    "dampingCoefficient",
    "extensions"
})
public class OutlierEffect
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<OutlierEffect>
{

    @XmlAttribute(name = "type", required = true)
    @JsonProperty("type")
    private String type;
    @XmlAttribute(name = "startTime", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("startTime")
    private Number startTime;
    @XmlAttribute(name = "magnitude", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("magnitude")
    private Number magnitude;
    @XmlAttribute(name = "dampingCoefficient")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("dampingCoefficient")
    private Number dampingCoefficient;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371269L;

    public OutlierEffect() {
    }

    @ValueConstructor
    public OutlierEffect(
        @org.jpmml.model.annotations.Property("type")
        String type,
        @org.jpmml.model.annotations.Property("startTime")
        Number startTime,
        @org.jpmml.model.annotations.Property("magnitude")
        Number magnitude) {
        this.type = type;
        this.startTime = startTime;
        this.magnitude = magnitude;
    }

    public String requireType() {
        if (this.type == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTLIEREFFECT_TYPE);
        }
        return this.type;
    }

    public String getType() {
        return type;
    }

    public OutlierEffect setType(
        @org.jpmml.model.annotations.Property("type")
        String type) {
        this.type = type;
        return this;
    }

    public Number requireStartTime() {
        if (this.startTime == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTLIEREFFECT_STARTTIME);
        }
        return this.startTime;
    }

    public Number getStartTime() {
        return startTime;
    }

    public OutlierEffect setStartTime(
        @org.jpmml.model.annotations.Property("startTime")
        Number startTime) {
        this.startTime = startTime;
        return this;
    }

    public Number requireMagnitude() {
        if (this.magnitude == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTLIEREFFECT_MAGNITUDE);
        }
        return this.magnitude;
    }

    public Number getMagnitude() {
        return magnitude;
    }

    public OutlierEffect setMagnitude(
        @org.jpmml.model.annotations.Property("magnitude")
        Number magnitude) {
        this.magnitude = magnitude;
        return this;
    }

    public Number getDampingCoefficient() {
        return dampingCoefficient;
    }

    public OutlierEffect setDampingCoefficient(
        @org.jpmml.model.annotations.Property("dampingCoefficient")
        Number dampingCoefficient) {
        this.dampingCoefficient = dampingCoefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public OutlierEffect addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
