
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Correlations", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "correlationFields",
    "correlationValues",
    "correlationMethods"
})
@JsonRootName("Correlations")
@JsonPropertyOrder({
    "extensions",
    "correlationFields",
    "correlationValues",
    "correlationMethods"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class Correlations
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Correlations>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "CorrelationFields", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("CorrelationFields")
    private CorrelationFields correlationFields;
    @XmlElement(name = "CorrelationValues", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("CorrelationValues")
    private CorrelationValues correlationValues;
    @XmlElement(name = "CorrelationMethods", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("CorrelationMethods")
    private CorrelationMethods correlationMethods;
    private final static long serialVersionUID = 67371271L;

    public Correlations() {
    }

    @ValueConstructor
    public Correlations(
        @org.jpmml.model.annotations.Property("correlationFields")
        CorrelationFields correlationFields,
        @org.jpmml.model.annotations.Property("correlationValues")
        CorrelationValues correlationValues) {
        this.correlationFields = correlationFields;
        this.correlationValues = correlationValues;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Correlations addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public CorrelationFields requireCorrelationFields() {
        if (this.correlationFields == null) {
            throw new MissingElementException(this, PMMLElements.CORRELATIONS_CORRELATIONFIELDS);
        }
        return this.correlationFields;
    }

    public CorrelationFields getCorrelationFields() {
        return correlationFields;
    }

    public Correlations setCorrelationFields(
        @org.jpmml.model.annotations.Property("correlationFields")
        CorrelationFields correlationFields) {
        this.correlationFields = correlationFields;
        return this;
    }

    public CorrelationValues requireCorrelationValues() {
        if (this.correlationValues == null) {
            throw new MissingElementException(this, PMMLElements.CORRELATIONS_CORRELATIONVALUES);
        }
        return this.correlationValues;
    }

    public CorrelationValues getCorrelationValues() {
        return correlationValues;
    }

    public Correlations setCorrelationValues(
        @org.jpmml.model.annotations.Property("correlationValues")
        CorrelationValues correlationValues) {
        this.correlationValues = correlationValues;
        return this;
    }

    public CorrelationMethods getCorrelationMethods() {
        return correlationMethods;
    }

    public Correlations setCorrelationMethods(
        @org.jpmml.model.annotations.Property("correlationMethods")
        CorrelationMethods correlationMethods) {
        this.correlationMethods = correlationMethods;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCorrelationFields(), getCorrelationValues(), getCorrelationMethods());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
