
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "ARIMA", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "nonseasonalComponent",
    "seasonalComponent",
    "dynamicRegressors",
    "maximumLikelihoodStat",
    "outlierEffects"
})
@JsonRootName("ARIMA")
@JsonPropertyOrder({
    "rmse",
    "transformation",
    "constantTerm",
    "predictionMethod",
    "extensions",
    "nonseasonalComponent",
    "seasonalComponent",
    "dynamicRegressors",
    "maximumLikelihoodStat",
    "outlierEffects"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class ARIMA
    extends Algorithm
    implements HasExtensions<ARIMA> , HasDynamicRegressors<ARIMA>
{

    @XmlAttribute(name = "RMSE")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("RMSE")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private Number rmse;
    @XmlAttribute(name = "transformation")
    @JsonProperty("transformation")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private ARIMA.Transformation transformation;
    @XmlAttribute(name = "constantTerm")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("constantTerm")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private Number constantTerm;
    @XmlAttribute(name = "predictionMethod")
    @JsonProperty("predictionMethod")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private ARIMA.PredictionMethod predictionMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private List<Extension> extensions;
    @XmlElement(name = "NonseasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NonseasonalComponent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private NonseasonalComponent nonseasonalComponent;
    @XmlElement(name = "SeasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SeasonalComponent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private SeasonalComponent seasonalComponent;
    @XmlElement(name = "DynamicRegressor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DynamicRegressor")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private List<DynamicRegressor> dynamicRegressors;
    @XmlElement(name = "MaximumLikelihoodStat", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MaximumLikelihoodStat")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private MaximumLikelihoodStat maximumLikelihoodStat;
    @XmlElement(name = "OutlierEffect", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("OutlierEffect")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private List<OutlierEffect> outlierEffects;
    private final static Number DEFAULT_CONSTANT_TERM = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371271L;

    public Number getRMSE() {
        return rmse;
    }

    public ARIMA setRMSE(
        @Property("rmse")
        Number rmse) {
        this.rmse = rmse;
        return this;
    }

    public ARIMA.Transformation getTransformation() {
        if (transformation == null) {
            return ARIMA.Transformation.NONE;
        } else {
            return transformation;
        }
    }

    public ARIMA setTransformation(
        @Property("transformation")
        ARIMA.Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Number getConstantTerm() {
        if (constantTerm == null) {
            return DEFAULT_CONSTANT_TERM;
        } else {
            return constantTerm;
        }
    }

    public ARIMA setConstantTerm(
        @Property("constantTerm")
        Number constantTerm) {
        this.constantTerm = constantTerm;
        return this;
    }

    public ARIMA.PredictionMethod getPredictionMethod() {
        if (predictionMethod == null) {
            return ARIMA.PredictionMethod.CONDITIONAL_LEAST_SQUARES;
        } else {
            return predictionMethod;
        }
    }

    public ARIMA setPredictionMethod(
        @Property("predictionMethod")
        ARIMA.PredictionMethod predictionMethod) {
        this.predictionMethod = predictionMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARIMA addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public NonseasonalComponent getNonseasonalComponent() {
        return nonseasonalComponent;
    }

    public ARIMA setNonseasonalComponent(
        @Property("nonseasonalComponent")
        NonseasonalComponent nonseasonalComponent) {
        this.nonseasonalComponent = nonseasonalComponent;
        return this;
    }

    public SeasonalComponent getSeasonalComponent() {
        return seasonalComponent;
    }

    public ARIMA setSeasonalComponent(
        @Property("seasonalComponent")
        SeasonalComponent seasonalComponent) {
        this.seasonalComponent = seasonalComponent;
        return this;
    }

    @Override
    public boolean hasDynamicRegressors() {
        return ((this.dynamicRegressors!= null)&&(!this.dynamicRegressors.isEmpty()));
    }

    @Override
    public List<DynamicRegressor> getDynamicRegressors() {
        if (dynamicRegressors == null) {
            dynamicRegressors = new ArrayList<DynamicRegressor>();
        }
        return this.dynamicRegressors;
    }

    @Override
    public ARIMA addDynamicRegressors(DynamicRegressor... dynamicRegressors) {
        getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    public MaximumLikelihoodStat getMaximumLikelihoodStat() {
        return maximumLikelihoodStat;
    }

    public ARIMA setMaximumLikelihoodStat(
        @Property("maximumLikelihoodStat")
        MaximumLikelihoodStat maximumLikelihoodStat) {
        this.maximumLikelihoodStat = maximumLikelihoodStat;
        return this;
    }

    public boolean hasOutlierEffects() {
        return ((this.outlierEffects!= null)&&(!this.outlierEffects.isEmpty()));
    }

    public List<OutlierEffect> getOutlierEffects() {
        if (outlierEffects == null) {
            outlierEffects = new ArrayList<OutlierEffect>();
        }
        return this.outlierEffects;
    }

    public ARIMA addOutlierEffects(OutlierEffect... outlierEffects) {
        getOutlierEffects().addAll(Arrays.asList(outlierEffects));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNonseasonalComponent(), getSeasonalComponent());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, getDynamicRegressors());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMaximumLikelihoodStat());
            }
            if ((status == VisitorAction.CONTINUE)&&hasOutlierEffects()) {
                status = PMMLObject.traverse(visitor, getOutlierEffects());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum PredictionMethod
        implements StringValue<ARIMA.PredictionMethod>
    {

        @XmlEnumValue("conditionalLeastSquares")
        @JsonProperty("conditionalLeastSquares")
        CONDITIONAL_LEAST_SQUARES("conditionalLeastSquares"),
        @XmlEnumValue("exactLeastSquares")
        @JsonProperty("exactLeastSquares")
        EXACT_LEAST_SQUARES("exactLeastSquares");
        private final String value;

        PredictionMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ARIMA.PredictionMethod fromValue(String v) {
            for (ARIMA.PredictionMethod c: ARIMA.PredictionMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Transformation
        implements StringValue<ARIMA.Transformation>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("logarithmic")
        @JsonProperty("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("squareroot")
        @JsonProperty("squareroot")
        SQUAREROOT("squareroot");
        private final String value;

        Transformation(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ARIMA.Transformation fromValue(String v) {
            for (ARIMA.Transformation c: ARIMA.Transformation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
