
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ARMAPart", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "ar",
    "ma"
})
@JsonRootName("ARMAPart")
@JsonPropertyOrder({
    "constant",
    "p",
    "q",
    "extensions",
    "ar",
    "ma"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class ARMAPart
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ARMAPart> , HasRequiredARMA<ARMAPart>
{

    @XmlAttribute(name = "constant")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("constant")
    private Number constant;
    @XmlAttribute(name = "p", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("p")
    private Integer p;
    @XmlAttribute(name = "q", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("q")
    private Integer q;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AR", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("AR")
    private AR ar;
    @XmlElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MA")
    private MA ma;
    private final static Number DEFAULT_CONSTANT = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371271L;

    public ARMAPart() {
    }

    @ValueConstructor
    public ARMAPart(
        @org.jpmml.model.annotations.Property("p")
        Integer p,
        @org.jpmml.model.annotations.Property("q")
        Integer q,
        @org.jpmml.model.annotations.Property("ar")
        AR ar,
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.p = p;
        this.q = q;
        this.ar = ar;
        this.ma = ma;
    }

    public Number getConstant() {
        if (constant == null) {
            return DEFAULT_CONSTANT;
        } else {
            return constant;
        }
    }

    public ARMAPart setConstant(
        @org.jpmml.model.annotations.Property("constant")
        Number constant) {
        this.constant = constant;
        return this;
    }

    @Override
    public Integer requireP() {
        if (this.p == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ARMAPART_P);
        }
        return this.p;
    }

    @Override
    public Integer getP() {
        return p;
    }

    @Override
    public ARMAPart setP(
        @org.jpmml.model.annotations.Property("p")
        Integer p) {
        this.p = p;
        return this;
    }

    @Override
    public Integer requireQ() {
        if (this.q == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ARMAPART_Q);
        }
        return this.q;
    }

    @Override
    public Integer getQ() {
        return q;
    }

    @Override
    public ARMAPart setQ(
        @org.jpmml.model.annotations.Property("q")
        Integer q) {
        this.q = q;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARMAPart addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public AR requireAR() {
        if (this.ar == null) {
            throw new MissingElementException(this, PMMLElements.ARMAPART_AR);
        }
        return this.ar;
    }

    @Override
    public AR getAR() {
        return ar;
    }

    @Override
    public ARMAPart setAR(
        @org.jpmml.model.annotations.Property("ar")
        AR ar) {
        this.ar = ar;
        return this;
    }

    @Override
    public MA requireMA() {
        if (this.ma == null) {
            throw new MissingElementException(this, PMMLElements.ARMAPART_MA);
        }
        return this.ma;
    }

    @Override
    public MA getMA() {
        return ma;
    }

    @Override
    public ARMAPart setMA(
        @org.jpmml.model.annotations.Property("ma")
        MA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAR(), getMA());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
