
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasTargetFieldReference;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DynamicRegressor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "numerator",
    "denominator",
    "regressorValues"
})
@JsonRootName("DynamicRegressor")
@JsonPropertyOrder({
    "field",
    "transformation",
    "delay",
    "futureValuesMethod",
    "targetField",
    "extensions",
    "numerator",
    "denominator",
    "regressorValues"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class DynamicRegressor
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DynamicRegressor> , HasFieldReference<DynamicRegressor> , HasTargetFieldReference<DynamicRegressor>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "transformation")
    @JsonProperty("transformation")
    private DynamicRegressor.Transformation transformation;
    @XmlAttribute(name = "delay")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("delay")
    private Integer delay;
    @XmlAttribute(name = "futureValuesMethod")
    @JsonProperty("futureValuesMethod")
    private DynamicRegressor.FutureValuesMethod futureValuesMethod;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetField")
    private String targetField;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Numerator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Numerator")
    private Numerator numerator;
    @XmlElement(name = "Denominator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Denominator")
    private Denominator denominator;
    @XmlElement(name = "RegressorValues", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("RegressorValues")
    private RegressorValues regressorValues;
    private final static Integer DEFAULT_DELAY = new IntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371271L;

    public DynamicRegressor() {
    }

    @ValueConstructor
    public DynamicRegressor(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public DynamicRegressor(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DYNAMICREGRESSOR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public DynamicRegressor setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public DynamicRegressor.Transformation getTransformation() {
        if (transformation == null) {
            return DynamicRegressor.Transformation.NONE;
        } else {
            return transformation;
        }
    }

    public DynamicRegressor setTransformation(
        @org.jpmml.model.annotations.Property("transformation")
        DynamicRegressor.Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Integer getDelay() {
        if (delay == null) {
            return DEFAULT_DELAY;
        } else {
            return delay;
        }
    }

    public DynamicRegressor setDelay(
        @org.jpmml.model.annotations.Property("delay")
        Integer delay) {
        this.delay = delay;
        return this;
    }

    public DynamicRegressor.FutureValuesMethod getFutureValuesMethod() {
        if (futureValuesMethod == null) {
            return DynamicRegressor.FutureValuesMethod.CONSTANT;
        } else {
            return futureValuesMethod;
        }
    }

    public DynamicRegressor setFutureValuesMethod(
        @org.jpmml.model.annotations.Property("futureValuesMethod")
        DynamicRegressor.FutureValuesMethod futureValuesMethod) {
        this.futureValuesMethod = futureValuesMethod;
        return this;
    }

    @Override
    public String getTargetField() {
        return targetField;
    }

    @Override
    public DynamicRegressor setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DynamicRegressor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Numerator getNumerator() {
        return numerator;
    }

    public DynamicRegressor setNumerator(
        @org.jpmml.model.annotations.Property("numerator")
        Numerator numerator) {
        this.numerator = numerator;
        return this;
    }

    public Denominator getDenominator() {
        return denominator;
    }

    public DynamicRegressor setDenominator(
        @org.jpmml.model.annotations.Property("denominator")
        Denominator denominator) {
        this.denominator = denominator;
        return this;
    }

    public RegressorValues getRegressorValues() {
        return regressorValues;
    }

    public DynamicRegressor setRegressorValues(
        @org.jpmml.model.annotations.Property("regressorValues")
        RegressorValues regressorValues) {
        this.regressorValues = regressorValues;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNumerator(), getDenominator(), getRegressorValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum FutureValuesMethod
        implements StringValue<DynamicRegressor.FutureValuesMethod>
    {

        @XmlEnumValue("constant")
        @JsonProperty("constant")
        CONSTANT("constant"),
        @XmlEnumValue("trend")
        @JsonProperty("trend")
        TREND("trend"),
        @XmlEnumValue("stored")
        @JsonProperty("stored")
        STORED("stored"),
        @XmlEnumValue("otherModel")
        @JsonProperty("otherModel")
        OTHER_MODEL("otherModel"),
        @XmlEnumValue("userSupplied")
        @JsonProperty("userSupplied")
        USER_SUPPLIED("userSupplied");
        private final String value;

        FutureValuesMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DynamicRegressor.FutureValuesMethod fromValue(String v) {
            for (DynamicRegressor.FutureValuesMethod c: DynamicRegressor.FutureValuesMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Transformation
        implements StringValue<DynamicRegressor.Transformation>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("logarithmic")
        @JsonProperty("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("squareroot")
        @JsonProperty("squareroot")
        SQUAREROOT("squareroot");
        private final String value;

        Transformation(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static DynamicRegressor.Transformation fromValue(String v) {
            for (DynamicRegressor.Transformation c: DynamicRegressor.Transformation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
