
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BaselineStratum", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "baselineCells"
})
@JsonRootName("BaselineStratum")
@JsonPropertyOrder({
    "value",
    "label",
    "maxTime",
    "extensions",
    "baselineCells"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class BaselineStratum
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaselineStratum> , HasValue<BaselineStratum>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "label")
    @JsonProperty("label")
    private String label;
    @XmlAttribute(name = "maxTime", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("maxTime")
    private Number maxTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BaselineCell")
    private List<BaselineCell> baselineCells;
    private final static long serialVersionUID = 67371272L;

    public BaselineStratum() {
    }

    @ValueConstructor
    public BaselineStratum(
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("maxTime")
        Number maxTime) {
        this.value = value;
        this.maxTime = maxTime;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINESTRATUM_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public BaselineStratum setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    public String getLabel() {
        return label;
    }

    public BaselineStratum setLabel(
        @org.jpmml.model.annotations.Property("label")
        String label) {
        this.label = label;
        return this;
    }

    public Number requireMaxTime() {
        if (this.maxTime == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASELINESTRATUM_MAXTIME);
        }
        return this.maxTime;
    }

    public Number getMaxTime() {
        return maxTime;
    }

    public BaselineStratum setMaxTime(
        @org.jpmml.model.annotations.Property("maxTime")
        Number maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BaselineStratum addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineCells() {
        return ((this.baselineCells!= null)&&(!this.baselineCells.isEmpty()));
    }

    public List<BaselineCell> requireBaselineCells() {
        if ((this.baselineCells == null)||this.baselineCells.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BASELINESTRATUM_BASELINECELLS);
        }
        return this.baselineCells;
    }

    public List<BaselineCell> getBaselineCells() {
        if (baselineCells == null) {
            baselineCells = new ArrayList<BaselineCell>();
        }
        return this.baselineCells;
    }

    public BaselineStratum addBaselineCells(BaselineCell... baselineCells) {
        getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
