
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "NonseasonalComponent", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "ar",
    "ma"
})
@JsonRootName("NonseasonalComponent")
@JsonPropertyOrder({
    "p",
    "d",
    "q",
    "extensions",
    "ar",
    "ma"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class NonseasonalComponent
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NonseasonalComponent> , HasARIMA<NonseasonalComponent>
{

    @XmlAttribute(name = "p")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("p")
    private Integer p;
    @XmlAttribute(name = "d")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("d")
    private Integer d;
    @XmlAttribute(name = "q")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("q")
    private Integer q;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AR", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("AR")
    private AR ar;
    @XmlElement(name = "MA", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MA")
    private MA ma;
    private final static Integer DEFAULT_P = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static Integer DEFAULT_D = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static Integer DEFAULT_Q = new NonNegativeIntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371272L;

    @Override
    public Integer getP() {
        if (p == null) {
            return DEFAULT_P;
        } else {
            return p;
        }
    }

    @Override
    public NonseasonalComponent setP(
        @Property("p")
        Integer p) {
        this.p = p;
        return this;
    }

    @Override
    public Integer getD() {
        if (d == null) {
            return DEFAULT_D;
        } else {
            return d;
        }
    }

    @Override
    public NonseasonalComponent setD(
        @Property("d")
        Integer d) {
        this.d = d;
        return this;
    }

    @Override
    public Integer getQ() {
        if (q == null) {
            return DEFAULT_Q;
        } else {
            return q;
        }
    }

    @Override
    public NonseasonalComponent setQ(
        @Property("q")
        Integer q) {
        this.q = q;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NonseasonalComponent addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public AR getAR() {
        return ar;
    }

    @Override
    public NonseasonalComponent setAR(
        @Property("ar")
        AR ar) {
        this.ar = ar;
        return this;
    }

    @Override
    public MA getMA() {
        return ma;
    }

    @Override
    public NonseasonalComponent setMA(
        @Property("ma")
        MA ma) {
        this.ma = ma;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAR(), getMA());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
