
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BlockIndicator", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("BlockIndicator")
@JsonPropertyOrder({
    "field",
    "extensions"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
public class BlockIndicator
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BlockIndicator> , HasFieldReference<BlockIndicator>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371272L;

    public BlockIndicator() {
    }

    @ValueConstructor
    public BlockIndicator(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public BlockIndicator(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BLOCKINDICATOR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public BlockIndicator setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public BlockIndicator addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
