
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("FieldColumnPair")
@JsonPropertyOrder({
    "field",
    "column",
    "extensions"
})
public class FieldColumnPair
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<FieldColumnPair> , HasFieldReference<FieldColumnPair>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "column", required = true)
    @JsonProperty("column")
    private String column;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371272L;

    public FieldColumnPair() {
    }

    @ValueConstructor
    public FieldColumnPair(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("column")
        String column) {
        this.field = field;
        this.column = column;
    }

    @AlternateValueConstructor
    public FieldColumnPair(Field<?> field, String column) {
        this(((field!= null)?field.requireName():null), column);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDCOLUMNPAIR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public FieldColumnPair setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public String requireColumn() {
        if (this.column == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDCOLUMNPAIR_COLUMN);
        }
        return this.column;
    }

    public String getColumn() {
        return column;
    }

    public FieldColumnPair setColumn(
        @org.jpmml.model.annotations.Property("column")
        String column) {
        this.column = column;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public FieldColumnPair addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
