
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("GaussianDistribution")
@JsonPropertyOrder({
    "mean",
    "variance",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class GaussianDistribution
    extends ContinuousDistribution
    implements HasExtensions<GaussianDistribution>
{

    @XmlAttribute(name = "mean", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("mean")
    private Number mean;
    @XmlAttribute(name = "variance", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("variance")
    private Number variance;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371272L;

    public GaussianDistribution() {
    }

    @ValueConstructor
    public GaussianDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Number mean,
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public Number requireMean() {
        if (this.mean == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GAUSSIANDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Number getMean() {
        return mean;
    }

    public GaussianDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Number mean) {
        this.mean = mean;
        return this;
    }

    public Number requireVariance() {
        if (this.variance == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GAUSSIANDISTRIBUTION_VARIANCE);
        }
        return this.variance;
    }

    public Number getVariance() {
        return variance;
    }

    public GaussianDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Number variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GaussianDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
