
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "REAL-SparseArray", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "indices",
    "entries"
})
@JsonRootName("REAL-SparseArray")
@JsonPropertyOrder({
    "n",
    "defaultValue",
    "indices",
    "entries"
})
public class RealSparseArray
    extends SparseArray<Double>
{

    @XmlAttribute(name = "n")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("n")
    private Integer n;
    @XmlAttribute(name = "defaultValue")
    @JsonProperty("defaultValue")
    private Double defaultValue;
    @XmlList
    @XmlElement(name = "Indices", namespace = "http://www.dmg.org/PMML-4_4", type = Integer.class)
    @JsonProperty("Indices")
    private List<Integer> indices;
    @XmlList
    @XmlElement(name = "REAL-Entries", namespace = "http://www.dmg.org/PMML-4_4", type = Double.class)
    @JsonProperty("REAL-Entries")
    private List<Double> entries;
    private final static Double DEFAULT_DEFAULT_VALUE = 0.0D;
    private final static long serialVersionUID = 67371272L;

    @Override
    public Integer getN() {
        return n;
    }

    @Override
    public RealSparseArray setN(
        @Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public Double getDefaultValue() {
        if (defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        } else {
            return defaultValue;
        }
    }

    @Override
    public RealSparseArray setDefaultValue(
        @Property("defaultValue")
        Double defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean hasIndices() {
        return ((this.indices!= null)&&(!this.indices.isEmpty()));
    }

    @Override
    public List<Integer> getIndices() {
        if (indices == null) {
            indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    @Override
    public RealSparseArray addIndices(Integer... indices) {
        getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    @Override
    public boolean hasEntries() {
        return ((this.entries!= null)&&(!this.entries.isEmpty()));
    }

    @Override
    public List<Double> getEntries() {
        if (entries == null) {
            entries = new ArrayList<Double>();
        }
        return this.entries;
    }

    @Override
    public RealSparseArray addEntries(Double... entries) {
        getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
