
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "partition"
})
@JsonRootName("TargetValue")
@JsonPropertyOrder({
    "value",
    "displayValue",
    "priorProbability",
    "defaultValue",
    "extensions",
    "partition"
})
public class TargetValue
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayValue<TargetValue> , HasExtensions<TargetValue> , HasValue<TargetValue>
{

    @XmlAttribute(name = "value")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "displayValue")
    @JsonProperty("displayValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private String displayValue;
    @XmlAttribute(name = "priorProbability")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("priorProbability")
    private Number priorProbability;
    @XmlAttribute(name = "defaultValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("defaultValue")
    private Number defaultValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Partition")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    private Partition partition;
    private final static long serialVersionUID = 67371272L;

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TARGETVALUE_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public TargetValue setValue(
        @Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public TargetValue setDisplayValue(
        @Property("displayValue")
        String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Number requirePriorProbability() {
        if (this.priorProbability == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TARGETVALUE_PRIORPROBABILITY);
        }
        return this.priorProbability;
    }

    public Number getPriorProbability() {
        return priorProbability;
    }

    public TargetValue setPriorProbability(
        @Property("priorProbability")
        Number priorProbability) {
        this.priorProbability = priorProbability;
        return this;
    }

    public Number requireDefaultValue() {
        if (this.defaultValue == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TARGETVALUE_DEFAULTVALUE);
        }
        return this.defaultValue;
    }

    public Number getDefaultValue() {
        return defaultValue;
    }

    public TargetValue setDefaultValue(
        @Property("defaultValue")
        Number defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TargetValue addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public TargetValue setPartition(
        @Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPartition());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
