
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TriangularDistributionForBN", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "mean",
    "lower",
    "upper"
})
@JsonRootName("TriangularDistributionForBN")
@JsonPropertyOrder({
    "extensions",
    "mean",
    "lower",
    "upper"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class TriangularDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TriangularDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Mean", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Mean")
    private Mean mean;
    @XmlElement(name = "Lower", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Lower")
    private Lower lower;
    @XmlElement(name = "Upper", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Upper")
    private Upper upper;
    private final static long serialVersionUID = 67371272L;

    public TriangularDistribution() {
    }

    @ValueConstructor
    public TriangularDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean,
        @org.jpmml.model.annotations.Property("lower")
        Lower lower,
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.mean = mean;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TriangularDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Mean requireMean() {
        if (this.mean == null) {
            throw new MissingElementException(this, PMMLElements.TRIANGULARDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Mean getMean() {
        return mean;
    }

    public TriangularDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean) {
        this.mean = mean;
        return this;
    }

    public Lower requireLower() {
        if (this.lower == null) {
            throw new MissingElementException(this, PMMLElements.TRIANGULARDISTRIBUTION_LOWER);
        }
        return this.lower;
    }

    public Lower getLower() {
        return lower;
    }

    public TriangularDistribution setLower(
        @org.jpmml.model.annotations.Property("lower")
        Lower lower) {
        this.lower = lower;
        return this;
    }

    public Upper requireUpper() {
        if (this.upper == null) {
            throw new MissingElementException(this, PMMLElements.TRIANGULARDISTRIBUTION_UPPER);
        }
        return this.upper;
    }

    public Upper getUpper() {
        return upper;
    }

    public TriangularDistribution setUpper(
        @org.jpmml.model.annotations.Property("upper")
        Upper upper) {
        this.upper = upper;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMean(), getLower(), getUpper());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
