
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "comparisons"
})
@JsonRootName("ClusteringField")
@JsonPropertyOrder({
    "field",
    "centerField",
    "fieldWeight",
    "similarityScale",
    "compareFunction",
    "extensions",
    "comparisons"
})
public class ClusteringField
    extends ComparisonField<ClusteringField>
    implements HasExtensions<ClusteringField>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "isCenterField")
    @JsonProperty("isCenterField")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    private ClusteringField.CenterField centerField;
    @XmlAttribute(name = "fieldWeight")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("fieldWeight")
    private Number fieldWeight;
    @XmlAttribute(name = "similarityScale")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("similarityScale")
    private Number similarityScale;
    @XmlAttribute(name = "compareFunction")
    @JsonProperty("compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Comparisons", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Comparisons")
    private Comparisons comparisons;
    private final static Number DEFAULT_FIELD_WEIGHT = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371272L;

    public ClusteringField() {
    }

    @ValueConstructor
    public ClusteringField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public ClusteringField(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CLUSTERINGFIELD_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public ClusteringField setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public ClusteringField.CenterField getCenterField() {
        if (centerField == null) {
            return ClusteringField.CenterField.TRUE;
        } else {
            return centerField;
        }
    }

    public ClusteringField setCenterField(
        @org.jpmml.model.annotations.Property("centerField")
        ClusteringField.CenterField centerField) {
        this.centerField = centerField;
        return this;
    }

    @Override
    public Number getFieldWeight() {
        if (fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        } else {
            return fieldWeight;
        }
    }

    @Override
    public ClusteringField setFieldWeight(
        @org.jpmml.model.annotations.Property("fieldWeight")
        Number fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public Number getSimilarityScale() {
        return similarityScale;
    }

    @Override
    public ClusteringField setSimilarityScale(
        @org.jpmml.model.annotations.Property("similarityScale")
        Number similarityScale) {
        this.similarityScale = similarityScale;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return compareFunction;
    }

    @Override
    public ClusteringField setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ClusteringField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Comparisons getComparisons() {
        return comparisons;
    }

    public ClusteringField setComparisons(
        @org.jpmml.model.annotations.Property("comparisons")
        Comparisons comparisons) {
        this.comparisons = comparisons;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getComparisons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CenterField
        implements StringValue<ClusteringField.CenterField>
    {

        @XmlEnumValue("true")
        @JsonProperty("true")
        TRUE("true"),
        @XmlEnumValue("false")
        @JsonProperty("false")
        FALSE("false");
        private final String value;

        CenterField(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ClusteringField.CenterField fromValue(String v) {
            for (ClusteringField.CenterField c: ClusteringField.CenterField.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
