
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors",
    "coefficients"
})
@JsonRootName("SupportVectorMachine")
@JsonPropertyOrder({
    "targetCategory",
    "alternateTargetCategory",
    "threshold",
    "extensions",
    "supportVectors",
    "coefficients"
})
public class SupportVectorMachine
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SupportVectorMachine>
{

    @XmlAttribute(name = "targetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("targetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Object targetCategory;
    @XmlAttribute(name = "alternateTargetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("alternateTargetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Object alternateTargetCategory;
    @XmlAttribute(name = "threshold")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("threshold")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Number threshold;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SupportVectors")
    private SupportVectors supportVectors;
    @XmlElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Coefficients")
    private Coefficients coefficients;
    private final static long serialVersionUID = 67371272L;

    public SupportVectorMachine() {
    }

    @ValueConstructor
    public SupportVectorMachine(
        @org.jpmml.model.annotations.Property("coefficients")
        Coefficients coefficients) {
        this.coefficients = coefficients;
    }

    public Object requireTargetCategory() {
        if (this.targetCategory == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SUPPORTVECTORMACHINE_TARGETCATEGORY);
        }
        return this.targetCategory;
    }

    public Object getTargetCategory() {
        return targetCategory;
    }

    public SupportVectorMachine setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        Object targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public Object requireAlternateTargetCategory() {
        if (this.alternateTargetCategory == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY);
        }
        return this.alternateTargetCategory;
    }

    public Object getAlternateTargetCategory() {
        return alternateTargetCategory;
    }

    public SupportVectorMachine setAlternateTargetCategory(
        @org.jpmml.model.annotations.Property("alternateTargetCategory")
        Object alternateTargetCategory) {
        this.alternateTargetCategory = alternateTargetCategory;
        return this;
    }

    public Number getThreshold() {
        return threshold;
    }

    public SupportVectorMachine setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectorMachine addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public SupportVectors getSupportVectors() {
        return supportVectors;
    }

    public SupportVectorMachine setSupportVectors(
        @org.jpmml.model.annotations.Property("supportVectors")
        SupportVectors supportVectors) {
        this.supportVectors = supportVectors;
        return this;
    }

    public Coefficients requireCoefficients() {
        if (this.coefficients == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINE_COEFFICIENTS);
        }
        return this.coefficients;
    }

    public Coefficients getCoefficients() {
        return coefficients;
    }

    public SupportVectorMachine setCoefficients(
        @org.jpmml.model.annotations.Property("coefficients")
        Coefficients coefficients) {
        this.coefficients = coefficients;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSupportVectors(), getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
